###--- >>> `Lanczos2' <<<----- Generated data

	## alias	 help(Lanczos2)

##___ Examples ___:

data(Lanczos2)
plot(y ~ x, data = Lanczos2)
## plot log response to see the number of exponential terms
plot(y ~ x, data = Lanczos2, log = "y")
##Don't run: 
##D ## Numerical derivatives do not produce sufficient accuracy to converge
##D fm1 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
##D            data = Lanczos2, trace = TRUE,
##D            start = c(b1 = 1.2, b2 = 0.3, b3 = 5.6, b4 = 5.5,
##D                      b5 = 6.5, b6 = 7.6))

##Don't run: 
##D ## Numerical derivatives do not produce sufficient accuracy to converge
##D fm2 <- nls(y ~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
##D            data = Lanczos2, trace = TRUE,
##D            start = c(b1 = 0.5, b2 = 0.7, b3 = 3.6, b4 = 4.2,
##D                      b5 = 4, b6 = 6.3))

##Don't run: 
##D ## Numerical derivatives do not produce sufficient accuracy to converge
##D fm3 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
##D            data = Lanczos2, trace = TRUE, algorithm = "plinear",
##D            start = c(b2 = 0.3, b4 = 5.5, b6 = 7.6))

##Don't run: 
##D ## Numerical derivatives do not produce sufficient accuracy to converge
##D fm4 <- nls(y ~ exp(outer(x,-c(b2, b4, b6))),
##D            data = Lanczos2, trace = TRUE, algorithm = "plinear",
##D            start = c(b2 = 0.7, b4 = 4.2, b6 = 6.3))

## Use analytic derivatives
Lanczos <- deriv(~ b1*exp(-b2*x) + b3*exp(-b4*x) + b5*exp(-b6*x),
                 paste("b", 1:6, sep = ""),
                 function(x, b1, b2, b3, b4, b5, b6){})
fm5 <- nls(y ~ Lanczos(x, b1, b2, b3, b4, b5, b6),
           data = Lanczos2, trace = TRUE,
           start = c(b1 = 1.2, b2 = 0.3, b3 = 5.6, b4 = 5.5,
                     b5 = 6.5, b6 = 7.6))
fm6 <- nls(y ~ Lanczos(x, b1, b2, b3, b4, b5, b6),
           data = Lanczos2, trace = TRUE,
           start = c(b1 = 0.5, b2 = 0.7, b3 = 3.6, b4 = 4.2,
                     b5 = 4, b6 = 6.3))

## Keywords: 'datasets'.


