###--- >>> `Stream read functions' <<<----- Read Binary Data from a Stream

	## alias	 help(readint)
	## alias	 help(readfloat)
	## alias	 help(readchar)
	## alias	 help(readcomplex)
	## alias	 help(readlines)

##___ Examples ___:

## find out endian-ness
if(R.version$major == 1 && R.version$minor >= 2.0) .Platform$endian

s <- openstream("mydata", "write")
writeint(s, 1:10, 1)
writeint(s, 21:30, 2)
writeint(s, 41:50, 4)
writefloat(s, 401:410, 4)
writefloat(s, 801:810, 8)
writechar(s, c("a string", "or two"), asciiz = TRUE)
closestream(s)

s <- openstream("mydata", "read")
readint(s, 10, 1)
readint(s, 10, 2)
readint(s, 10, 4)
readfloat(s, 10, 4)
readfloat(s, 10, 8)
readchar(s, 2)
closestream(s)

dump("openstream", "mydata")
s <- openstream("mydata")
readlines(s, 2)
closestream(s)

unlink("mydata")

## Keywords: 'file'.


