###--- >>> `Hyperbolic' <<<----- Hyperbolic Functions

	## alias	 help(cosh)
	## alias	 help(sinh)
	## alias	 help(tanh)
	## alias	 help(acosh)
	## alias	 help(asinh)
	## alias	 help(atanh)

##___ Examples ___:

Ceps <- .Machine$double.eps # ``Computer epsilon''
x <- rnorm(500)
stopifnot(
 abs(cosh(x) - (exp(x) + exp(-x))/2) < 10*Ceps,
 abs(sinh(x) - (exp(x) - exp(-x))/2) < 10*Ceps,
 Mod(cosh(x) - cos(1i*x))       < 10*Ceps,
 Mod(sinh(x) - sin(1i*x)/1i)    < 10*Ceps,
 abs(tanh(x)*cosh(x) - sinh(x)) < 10*Ceps
)

## Inverse:
all(abs(asinh(sinh(x)) - x) < 10*Ceps)
x[abs(acosh(cosh(x)) - abs(x)) > 100*Ceps] #- imprecise for small x
all(abs(atanh(tanh(x)) - x) < 100*Ceps)

all(abs(asinh(x) - log(x + sqrt(x^2 + 1))) < 10*Ceps)
cx <- cosh(x)
all(abs(acosh(cx) - log(cx + sqrt(cx^2 - 1))) < 1000*Ceps)

## Keywords: 'math'.


