###--- >>> `as.POSIX*' <<<----- Date-time Conversion Functions

	## alias	 help(as.POSIXct)
	## alias	 help(as.POSIXct.default)
	## alias	 help(as.POSIXct.POSIXlt)
	## alias	 help(as.POSIXct.date)
	## alias	 help(as.POSIXct.dates)
	## alias	 help(as.POSIXlt)

##___ Examples ___:

(z <- Sys.time())             # the current date, as class "POSIXct"
unclass(z)                    # a large integer
floor(unclass(z)/86400)       # the number of days since 1970-01-01

 stopifnot(range(z) == z,
           min(z) == z,
           max(z) == z,
           mean(z) == z)

(z <- as.POSIXlt(Sys.time())) # the current date, as class "POSIXlt"
unlist(unclass(z))            # a list shown as a named vector

as.POSIXlt(Sys.time(), "GMT") # the current time in GMT

## Keywords: 'utilities', 'chron'.


