###--- >>> `cor' <<<----- Correlation, Variance and Covariance (Matrices)

	## alias	 help(var)
	## alias	 help(cor)
	## alias	 help(cov)

##___ Examples ___:

var(1:10)# 9.166667

var(1:5,1:5)# 2.5

## Two simple vectors
cor(1:10,2:11)# == 1


 stopifnot(is.na(var(1)) && !is.nan(var(1)))

## Correlation Matrix of Multivariate sample:
data(longley)
(Cl <- cor(longley))
## Graphical Correlation Matrix:
symnum(Cl) # highly correlated

##--- Missing value treatment:
data(swiss)
C1 <- cov(swiss)
range(eigen(C1, only=TRUE)$val) # 6.19  1921
swiss[1,2] <- swiss[7,3] <- swiss[25,5] <- NA # create 3 "missing"
##Don't run: 
##D  C2 <- cov(swiss) # Error: missing obs...

C2 <- cov(swiss, use = "complete")
range(eigen(C2, only=TRUE)$val) # 6.46  1930
C3 <- cov(swiss, use = "pairwise")
range(eigen(C3, only=TRUE)$val) # 6.19  1938

## Keywords: 'univar', 'multivariate', 'array'.


