###--- >>> `format' <<<----- Encode in a Common Format

	## alias	 help(format)
	## alias	 help(format.AsIs)
	## alias	 help(format.data.frame)
	## alias	 help(format.default)
	## alias	 help(format.factor)
	## alias	 help(format.pval)

##___ Examples ___:

format(1:10)

zz <- data.frame("(row names)"= c("aaaaa", "b"), check.names=FALSE)
format(zz)
format(zz, justify="left")

## use of nsmall
format(13.7)
format(13.7, nsmall=3)

## handling of quotes
zz <- data.frame(a=I("abc"), b=I("def\"gh"))
format(zz)
for(i in c(1:5,10,15:17,20)) cat(i,":\t",format(pi,digits=i),"\n")

p <- c(47,13,2,.1,.023,.0045, 1e-100)/1000
format.pval(p)
format.pval(p / 0.9)
format.pval(p / 0.9, dig=3)

## Keywords: 'character', 'print'.


