###--- >>> `merge' <<<----- Merge Two Data Frames

	## alias	 help(merge)
	## alias	 help(merge.default)
	## alias	 help(merge.data.frame)

##___ Examples ___:

authors <- data.frame(
    surname = c("Tukey", "Venables", "Tierney", "Ripley", "McNeil"),
    nationality = c("US", "Australia", "US", "UK", "Australia"),
    deceased = c("yes", rep("no", 4)))
books <- data.frame(
    name = c("Tukey", "Venables", "Tierney",
             "Ripley", "Ripley", "McNeil", "R Core"),
    title = c("Exploratory Data Analysis",
              "Modern Applied Statistics ...",
              "LISP-STAT",
              "Spatial Statistics", "Stochastic Simulation",
              "Interactive Data Analysis",
              "An Introduction to R"),
    other.author = c(NA, "Ripley", NA, NA, NA, NA,
                     "Venables & Smith"))

(m1 <- merge(authors, books, by.x = "surname", by.y = "name"))
(m2 <- merge(books, authors, by.x = "name", by.y = "surname"))
stopifnot(as.character(m1[,1]) == as.character(m2[,1]),
          all.equal(m1[, -1], m2[, -1][ names(m1)[-1] ]),
          dim(merge(m1, m2, by = integer(0))) == c(36, 10))

## "R core" is missing from authors and appears only here :
merge(authors, books, by.x = "surname", by.y = "name", all = TRUE)


 b2 <- books; names(b2)[1] <- names(authors)[1]

 merge(authors, b2, all.x = TRUE)
 merge(authors, b2, all.y = TRUE)

 ## empty d.f. :
 merge(authors, b2[7,])
                         
 merge(authors, b2[7,], all.y = TRUE)
 merge(authors, b2[7,], all.x = TRUE)


## Keywords: 'array', 'manip'.


