###--- >>> `postscript' <<<----- PostScript Graphics

	## alias	 help(postscript)
	## alias	 help(ps.options)
	## alias	 help(.PostScript.Options)
	## alias	 help(.ps.prolog)

##___ Examples ___:

##Don't run: 
##D # open the file "foo.ps" for graphics output
##D postscript("foo.ps")
##D # produce the desired graph(s)
##D dev.off()              # turn off the postscript device
##D postscript("|lp -dlw")
##D # produce the desired graph(s)
##D dev.off()              # plot will appear on printer


xx <- seq(0, 7, length=701)
yy <- sin(xx)/xx; yy[1] <- 1
plot(xx,yy)                     # produce the desired graph(s)


stopifnot(unlist(ps.options()) == unlist(.PostScript.Options))
ps.options(bg = "pink")
str(ps.options(reset = TRUE))

### ---- error checking of arguments: ----
ps.options(width=0:12, onefile=0, bg=pi)
# override the check for 'onefile', but not the others:
str(ps.options(width=0:12, onefile=1, bg=pi, override.check = c(F,T,F)))

##Don't run: ###  ---- Use TeX's Computer Modern fonts --- 
##D ## Only use alphanumeric chars here.
##D postscript(family=paste("/myfonts/afm/",
##D    c("cmr10", "cmbx10", "cmsl10", "cmbxsl10"), ".afm", sep=""))
##D ## The resultant postscript file can be used by dvips provided
##D ## font subsetting is disabled (by flag -j0)

## Keywords: 'device'.


