###--- >>> `qr' <<<----- The QR Decomposition of a Matrix

	## alias	 help(qr)
	## alias	 help(qr.coef)
	## alias	 help(qr.qy)
	## alias	 help(qr.qty)
	## alias	 help(qr.resid)
	## alias	 help(qr.fitted)
	## alias	 help(qr.solve)
	## alias	 help(is.qr)
	## alias	 help(as.qr)

##___ Examples ___:

hilbert <- function(n) { i <- 1:n; 1 / outer(i - 1, i, "+") }
h9 <- hilbert(9); h9
qr(h9)$rank           #--> only 7
qrh9 <- qr(h9, tol = 1e-10)
qrh9$rank             #--> 9
##-- Solve linear equation system  H %*% x = y :
y <- 1:9/10
x <- qr.solve(h9, y, tol = 1e-10) # or equivalently :
x <- qr.coef(qrh9, y) #-- is == but much better than
                      #-- solve(h9) %*% y
h9 %*% x              # = y

## tests of complex case
set.seed(1)
A <- matrix(rnorm(25), 5, 5, dimnames=list(1:5, letters[1:5]))
qr.solve(A, 1:5)
A[] <- as.complex(A)
qr.coef(qr(A), 1:5)
qr.solve(A, 1:5)
## check for rank-deficient cases
X <- cbind(1:3, 1:3, 1)
stopifnot(all.equal(qr.X(qr(X)), X))

## Keywords: 'algebra', 'array', 'regression'.


