est.VARX.ls               package:dse1               R Documentation

_E_s_t_i_m_a_t_e _a _V_A_R _T_S_m_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     Estimate a VAR TSmodel with (optionally) an exogenous input and 
     (optionally) a trend.

_U_s_a_g_e:

         est.VARX.ls(data, subtract.means=F, re.add.means=T, standardize=F, 
          unstandardize=T, max.lag=NULL, trend=F, lag.weight=1.0, warn=T) 

_A_r_g_u_m_e_n_t_s:

    data: A TSdata object.

subtract.means: If T subtract the means from the data before
          estimation.

re.add.means: If T and subtract.means is T then the mean is added back
          to the data and  the model is adjusted for the non-zero mean
          data when returned.

standardize: If T divide each series by its sample standard  deviation
          before estimation. Note that the mean is not subtracted
          unless subtract.means is T.

unstandardize: If T and standardize is T then the returned  model is
          adjusted to correspond to the original data.

   trend: If T a trend is estimated.

 max.lag: Number of lags to be used.

lag.weight: Weight between 0 and 1 to be applied to lagged data.  Lower
          weights mean lagged data is less important (more noisy).

    warn: If TRUE a warning message is issued when missing data (NA) is
          detected and the model predictions are reconstructed from the
          lsfit residuals.

_D_e_t_a_i_l_s:

     A VAR model is fitted by least squares regression using lsfit. The
     argument max.lag determines the number of lags. If a trend is not
     estimated the function est.VARX.ar may be preferred. Missing data
     is allowed in lsfit, but not (yet) by ARMA which generates the
     model predictions, etc., based on the estimated model and the
     data. (This is done to ensure the result is consistent with other
     estimation techniques.) In the case of missing data ARMA is not
     used and the model predictions, etc., are generated by adding the
     data and the lsfit residual. This is slightly different from using
     ARMA, especially with respect to initial conditions.

_V_a_l_u_e:

     A TSestModel object containing a TSmodel object which is a VAR
     model.

_R_e_f_e_r_e_n_c_e_s:

     P.D.Gilbert (1993) State Space and ARMA models: An overview of
     estimation and reduction.

_S_e_e _A_l_s_o:

     `est.SS.from.VARX' `est.SS.Mittnik' `bft' `est.VARX.ar'

_E_x_a_m_p_l_e_s:

         if(is.R()) data("eg1.DSE.data.diff", package="dse1")
         model <- est.VARX.ls(eg1.DSE.data.diff)

