l.SS                  package:dse1                  R Documentation

_E_v_a_l_u_a_t_e _a _s_t_a_t_e _s_p_a_c_e _T_S_m_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     Evaluate a state space TSmodel.

_U_s_a_g_e:

         l.SS(obj1, data, sampleT=NULL, predictT=NULL, error.weights=0,
              return.state=F, return.track=F, result=NULL, compiled=.DSECOMPILED,
              warn=T, return.debug.info=F)

_A_r_g_u_m_e_n_t_s:

   model: An 'SS' 'TSmodel' object.

    data: A TSdata object.

 sampleT: An integer indicating the last data point to use for one step
          ahead filter estimation. If NULL all available data is used. 

predictT: An integer indicating how far past the end of the sample
          predictions should  be made. For models with an input, input
          data must be provided up to predictT.  Output data is
          necessary only to sampleT. If NULL predictT is set to
          sampleT.

return.state: If T the element `filter$state' containing E[z(t)|y(t-1),
          u(t)] is  returned as part of the result. This can be a
          fairly large matrix. 

return.track: If T the element `filter$track' containing the
          expectation of the tracking  error given y(t-1) and u(t) is
          returned as part of the result. This can be an  very large
          array. 

  result: If result is not specified an object of class TSestModel is 
          returned. Otherwise, the specified element of
          `TSestModel$estimates' is returned.

compiled: If T the compiled version of the code is used. Otherwise the
          S version is used.

    warn: If FALSE then certain warning messages are turned off.

_D_e_t_a_i_l_s:

     This function is called by the function l() when the argument to l
     is a state space model. Using l() is usually preferable to calling
     l.SS directly. l.SS calls a compiled program unless compiled=F.
     The compiled version is much faster than the S version.

_V_a_l_u_e:

     Usually an object of class TSestModel (see TSestModel), but see
     result above.

_S_e_e _A_l_s_o:

     `l' `l.ARMA' `TSmodel' `TSestModel.object' `smoother'

_E_x_a_m_p_l_e_s:

     if(is.R()) data("eg1.DSE.data.diff", package="dse1")
     model <- to.SS(TSmodel(est.VARX.ls(eg1.DSE.data.diff)))
     lmodel <- l.SS(model,eg1.DSE.data.diff)

