theor.Lc.plot              package:ineq              R Documentation

_P_l_o_t _T_h_e_o_r_e_t_i_c_a_l _L_o_r_e_n_z _C_u_r_v_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     add theoretical Lorenz curves of income distributions in a Lorenz
     curve plot

_U_s_a_g_e:

     theor.Lc.plot(type=c("Singh-Maddala","Dagum","lognorm","Pareto","exponential"),parameter=0, col=2, lty=1)

_A_r_g_u_m_e_n_t_s:

    type: character string giving the income distribution. must be one
          of the strings in the default argument (the first character
          is sufficient). defaults to "Singh-Maddala".

parameter: vector containing parameters of the distributions

_A_u_t_h_o_r(_s):

     Achim Zeileis zeileis@ci.tuwien.ac.at

_R_e_f_e_r_e_n_c_e_s:

     C Dagum: Income Distribution Models, 1983, in: Johnson / Kotz
     (Eds): Encyclopedia of Statistical Sciences Vol.4, 27-34.

     J B McDonald: Some generalized functions for the size distribution
     of income, 1984, Econometrica 52, 647-664.

_S_e_e _A_l_s_o:

     `Lc', `Lc.plot'

_E_x_a_m_p_l_e_s:

     # income distribution of the USA in 1968 (in 10 classes)
     # x vector of class means, n vector of class frequencies
     x <- c(541, 1463, 2445, 3438, 4437, 5401, 6392, 8304, 11904, 22261)
     n <- c(482, 825, 722, 690, 661, 760, 745, 2140, 1911, 1024)

     # compute minimal Lorenz curve (= no inequality in each group)
     Lc.min <- Lc(x, n=n)
     # compute maximal Lorenz curve (limits of Mehran)
     Lc.max <- Lc.mehran(x,n)
     # plot both Lorenz curves in one plot                        
     Lc.plot(Lc.min)
     Lc.plot(Lc.max, new=T, col=4)

     # add the theoretic Lorenz curve of a Lognormal-distribution with (var=0.78)
     theor.Lc.plot(type="lognorm", parameter=0.78)
     # add the theoretic Lorenz curve of a Dagum-distribution
     theor.Lc.plot(type="Dagum", parameter=c(3.4,2.6))

