###--- >>> `mhtree' <<<----- Classification Tree for Model-based Gaussian hierarchical clustering.

	## alias	 help(print.mhtree)

##___ Examples ___:

data(iris)

# Ellipsoidal, equal volume, shape and orientation
mhtree(iris[,1:4], modelid = "EEE")

# Spherical, equal volume, fixed shape, variable orientation
shape <- c(1,1/2,1/3,1/4)
mhtree(iris[,1:4], modelid = "EFV", shape=shape)

# Spherical, equal volume (Ward's method).
mhtree(iris[,1:4], modelid = "EI")

# Ellipsoidal, equal volume, constant shape, variable orientation
mhtree(iris[,1:4], modelid = "VFV", shape=shape)

# Spherical, variable volume
mhtree(iris[,1:4], modelid = "VI")

# Unconstrained (default).
mhtree(iris[,1:4], modelid = "VVV")


## Keywords: 'cluster'.


