###--- >>> `pca' <<<----- Principal Components Analysis

	## alias	 help(pca)

##___ Examples ___:

data(iris)
iris <- as.matrix(iris[,1:4])
pcprim <- pca(iris)
# plot of first and second principal components
plot(pcprim$rproj[,1], pcprim$rproj[,2])
# variance explained by the principal components
pcprim$evals*100.0/sum(pcprim$evals)
# In the implementation of the S function `prcomp', different results are
# produced.  Here is how to obtain these results, using the function `pca'.
library(mva)
# Consider the following result of `prcomp':
old <- prcomp(iris)
# With `pca', one would do the following:
new <- pca(iris, method=7)

## Keywords: 'multivariate', 'algebra'.


