###--- >>> `princomp' <<<----- Principal Components Analysis

	## alias	 help(princomp)
	## alias	 help(plot.princomp)
	## alias	 help(print.princomp)
	## alias	 help(predict.princomp)
	## alias	 help(summary.princomp)
	## alias	 help(loadings)
	## alias	 help(screeplot)

##___ Examples ___:

## The variances of the variables in the
## USArrests data vary by orders of magnitude, so scaling is appropriate
data(USArrests)
(pc.cr <- princomp(USArrests))  # inappropriate
princomp(USArrests, cor = TRUE) # =^= prcomp(USArrests, scale=TRUE)
## Similar, but different:
## The standard deviations differ by a factor of sqrt(49/50)

summary(pc.cr <- princomp(USArrests, cor=TRUE))
loadings(pc.cr)
plot(pc.cr) # does a screeplot.
biplot(pc.cr)

## Keywords: 'multivariate'.


