###--- >>> `profiler.nls' <<<----- Constructor for Profiler Objects from nls Objects

	## alias	 help(profiler.nls)

##___ Examples ___:

data( BOD )
# obtain the fitted object
fm1 <- nls(demand ~ SSasympOrig( Time, A, lrc ), data = BOD)
# get the profile for the fitted model
prof1 <- profiler( fm1 )
# profile with A fixed at 16.0
prof1$getProfile(c(F,T), 16.0)
# vary lrc
prof1$setDefault(varying = c(F, T))
# fix A at 14.0 and starting estimate of lrc at -0.2
prof1$setDefault(params = c(14.0, -0.2))
# and get the profile
prof1$getProfile()
# finally, set defaults back to original estimates
prof1$setDefault()

## Keywords: 'nonlinear', 'regression', 'models'.


