###--- >>> `sm.density' <<<----- Nonparametric density estimation in one, two or three dimensions.

	## alias	 help(sm.density)
	## alias	 help(sm.density.1d)
	## alias	 help(sm.density.2d)
	## alias	 help(sm.density.3d)
	## alias	 help(sm.density.eval.1d)
	## alias	 help(sm.density.eval.2d)
	## alias	 help(sm.density.positive.1d)
	## alias	 help(sm.density.positive.2d)
	## alias	 help(sm.density.positive.grid)

##___ Examples ___:

#  A one-dimensional example
y <- rnorm(50)
sm.density(y, model = "Normal")

#  A two-dimensional example
y <- cbind(rnorm(50), rnorm(50))
sm.density(y, display = "image")

#  A three-dimensional example
y <- cbind(rnorm(50), rnorm(50), rnorm(50))
sm.density(y)

## Keywords: 'nonparametric', 'smooth'.


