###--- >>> `pstar' <<<----- Fit a p* Model Using a Logistic Approximation

	## alias	 help(pstar)

##___ Examples ___:

#Create a graph with expansiveness and popularity effects
in.str<-rnorm(20,0,3)
out.str<-rnorm(20,0,3)
tie.str<-outer(out.str,in.str,"+")
tie.p<-apply(tie.str,c(1,2),function(a){1/(1+exp(-a))})
g<-rgraph(20,tprob=tie.p)

#Fit a model with expansiveness only
p1<-pstar(g,effects="outdegree")
#Fit a model with expansiveness and popularity
p2<-pstar(g,effects=c("outdegree","indegree"))
#Fit a model with expansiveness, popularity, and mutuality
p3<-pstar(g,effects=c("outdegree","indegree","mutuality"))

#Compare the model AICs
extractAIC(p1)
extractAIC(p2)
extractAIC(p3)

## Keywords: 'models', 'multivariate', 'regression', 'network'.


