###--- >>> `structdist' <<<----- Find the Structural Distances Between Two or More Graphs

	## alias	 help(structdist)

##___ Examples ___:

#Generate two random graphs
g<-array(dim=c(3,5,5))
g[1,,]<-rgraph(5)
g[2,,]<-rgraph(5)

#Copy one of the graphs and permute it
g[3,,]<-rmperm(g[2,,])

#What are the structural distances between the labeled graphs?
structdist(g,exchange.list=1:5)

#What are the structural distances between the underlying unlabeled 
#graphs?
structdist(g,method="anneal", prob.init=0.9, prob.decay=0.85, 
    freeze.time=50, full.neighborhood=TRUE)

## Keywords: 'univar', 'multivariate', 'network'.


