bbnam.bf                 package:sna                 R Documentation

_E_s_t_i_m_a_t_e _B_a_y_e_s _F_a_c_t_o_r_s _f_o_r _t_h_e _b_b_n_a_m

_D_e_s_c_r_i_p_t_i_o_n:

     This function uses monte carlo integration to estimate the BFs,
     and tests the fixed probability, pooled, and pooled by actor
     models. (See `bbnam' for details.)

_U_s_a_g_e:

     bbnam.bf(dat, nprior=matrix(rep(0.5, dim(dat)[1]^2), 
         nrow = dim(dat)[1], ncol = dim(dat)[1]), em.fp=0.5, ep.fp=0.5, 
         emprior.pooled=c(1, 1), epprior.pooled=c(1, 1), 
         emprior.actor=cbind(rep(1, dim(dat)[1]), rep(1, dim(dat)[1])), 
         epprior.actor=cbind(rep(1, dim(dat)[1]), rep(1, dim(dat)[1])), 
         diag=FALSE, mode="digraph", reps=1000)

_A_r_g_u_m_e_n_t_s:

     dat: Data array to be analyzed.  This array must be of dimension m
          x n x n, where n is |V(G)|, the first dimension indexes the
          observer, the second indexes the sender of the relation, and
          the third dimension indexes the recipient of the relation. 
          (E.g., `dat[i,j,k]==1' implies that i observed j sending the
          relation in question to k.)  Note that only dichotomous data
          is supported at present, and missing values are permitted;
          the data collection pattern, however, is assumed to be
          ignorable, and hence the posterior inferences are implicitly
          conditional on the observation pattern. 

  nprior: Network prior matrix.  This must be a matrix of dimension n x
          n, containing the arc/edge priors for the criterion network. 
          (E.g., `nprior[i,j]' gives the prior probability of i sending
          the relation to j in the criterion graph.)  If no network
          prior is provided, an uninformative prior on the space of
          networks will be assumed (i.e., p(i->j)=0.5).  Missing values
          are not allowed. 

   em.fp: Probability of false negatives for the fixed probability
          model 

   ep.fp: Probability of false positives for the fixed probability
          model 

emprior.pooled: (alpha,beta) pairs for the (beta) false negative prior
          under the pooled model 

epprior.pooled: (alpha,beta) pairs for the (beta) false positive prior
          under the pooled model 

emprior.actor: Matrix of per observer (alpha,beta) pairs for the (beta)
          false negative prior under the per observer/actor model 

epprior.actor: Matrix of per observer (alpha,beta) pairs for the (beta)
          false negative prior under the per observer/actor model 

    diag: Boolean indicating whether or not the diagonal should be
          treated as valid data.  Set this true if and only if the
          criterion graph can contain loops.  Diag is false by default. 

    mode: String indicating the type of graph being evaluated. 
          "Digraph" indicates that edges should be interpreted as
          directed; "graph" indicates that edges are undirected.  Mode
          is set to "digraph" by default. 

    reps: Number of monte carlo draws to take 

_D_e_t_a_i_l_s:

     The bbnam model (detailed in the `bbnam' function help) is a
     fairly simple model for integrating informant reports regarding
     social network data.  `bbnam.bf' computes Bayes Factors
     (integrated likelihood ratios) for the three error submodels of
     the bbnam: fixed error probabilities, pooled error probabilities,
     and per observer/actor error probabilities.

_V_a_l_u_e:

     An object of class `bayes.factor'.

_N_o_t_e:

     It is important to be aware that the model parameter priors are
     essential components of the models to be compared; inappropriate
     parameter priors will result in misleading Bayes Factors.

_A_u_t_h_o_r(_s):

     Carter T. Butts ctb@andrew.cmu.edu

_R_e_f_e_r_e_n_c_e_s:

     Butts, C.T.  (1999).  ``Network Inference, Error, and Informant
     (In)Accuracy: A Bayesian Approach.''  CASOS Working Paper,
     Carnegie Mellon University.

     Robert, C.  (1994).  The Bayesian Choice: A Decision-Theoretic
     Motivation.  Springer.

_S_e_e _A_l_s_o:

     `bbnam'

_E_x_a_m_p_l_e_s:

