###--- >>> `xtable' <<<----- Create Export Tables

	## alias	 help(xtable)
	## alias	 help(xtable.anova)
	## alias	 help(xtable.aov)
	## alias	 help(xtable.aovlist)
	## alias	 help(xtable.data.frame)
	## alias	 help(xtable.glm)
	## alias	 help(xtable.lm)
	## alias	 help(xtable.matrix)
	## alias	 help(xtable.prcomp)
	## alias	 help(xtable.princomp)
	## alias	 help(xtable.summary.aov)
	## alias	 help(xtable.summary.aovlist)
	## alias	 help(xtable.summary.glm)
	## alias	 help(xtable.summary.lm)
	## alias	 help(xtable.summary.prcomp)

##___ Examples ___:


## Load example dataset
data(tli)

## Demonstrate data.frame
tli.table <- xtable(tli[1:20,])
digits(tli.table)[c(2,6)] <- 0
print(tli.table)
print(tli.table,type="html")

## Demonstrate matrix
design.matrix <- model.matrix(~ sex*grade, data=tli[1:20,])
design.table <- xtable(design.matrix)
print(design.table)
print(design.table,type="html")

## Demonstrate aov
fm1 <- aov(tlimth ~ sex + ethnicty + grade + disadvg, data=tli)
fm1.table <- xtable(fm1)
print(fm1.table)
print(fm1.table,type="html")

## Demonstrate lm
fm2 <- lm(tlimth ~ sex*ethnicty, data=tli)
fm2.table <- xtable(fm2)
print(fm2.table)
print(fm2.table,type="html")
print(xtable(anova(fm2)))
print(xtable(anova(fm2)),type="html")
fm2b <- lm(tlimth ~ ethnicty, data=tli)
print(xtable(anova(fm2b,fm2)))
print(xtable(anova(fm2b,fm2)),type="html")

## Demonstrate glm
fm3 <- glm(disadvg ~ ethnicty*grade, data=tli, family=binomial())
fm3.table <- xtable(fm3)
print(fm3.table)
print(fm3.table,type="html")
print(xtable(anova(fm3)))
print(xtable(anova(fm3)),type="html")

## Demonstrate aov
## Taken from help(aov) in R 1.1.1
## From Venables and Ripley (1997) p.210.
N <- c(0,1,0,1,1,1,0,0,0,1,1,0,1,1,0,0,1,0,1,0,1,1,0,0)
P <- c(1,1,0,0,0,1,0,1,1,1,0,0,0,1,0,1,1,0,0,1,0,1,1,0)
K <- c(1,0,0,1,0,1,1,0,0,1,0,1,0,1,1,0,0,0,1,1,1,0,1,0)
yield <- c(49.5,62.8,46.8,57.0,59.8,58.5,55.5,56.0,62.8,55.8,69.5,55.0,
           62.0,48.8,45.5,44.2,52.0,51.5,49.8,48.8,57.2,59.0,53.2,56.0)
npk <- data.frame(block=gl(6,4), N=factor(N), P=factor(P), K=factor(K), yield=yield)
npk.aov <- aov(yield ~ block + N*P*K, npk)
op <- options(contrasts=c("contr.helmert", "contr.treatment"))
npk.aovE <- aov(yield ~  N*P*K + Error(block), npk)
options(op)

summary(npk.aov)
print(xtable(npk.aov))
print(xtable(anova(npk.aov)))
print(xtable(summary(npk.aov)))

summary(npk.aovE)
print(xtable(npk.aovE),type="html")
print(xtable(summary(npk.aovE)),type="html")

## Demonstrate lm
## Taken from help(lm) in R 1.1.1
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2,10,20, labels=c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
print(xtable(lm.D9))
print(xtable(anova(lm.D9)))

## Demonstrate glm
## Taken from help(glm) in R 1.1.1
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 93: Randomized Controlled Trial :
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
d.AD <- data.frame(treatment, outcome, counts)
glm.D93 <- glm(counts ~ outcome + treatment, family=poisson())
print(xtable(glm.D93))
print(xtable(anova(glm.D93)))

if(require(mva,quietly=TRUE)) {
  ## Demonstrate prcomp
  ## Taken from help(prcomp) in mva package of R 1.1.1
  data(USArrests)
  pr1 <- prcomp(USArrests)
  print(xtable(pr1))
  print(xtable(summary(pr1)))

  ## Demonstrate princomp
  ## Taken from help(princomp) in mva package of R 1.1.1
  pr2 <- princomp(USArrests)
  print(xtable(pr2))
}


  for(i in c("latex","html")) {
    print(tli.table,type=i,file=paste("xtable.",i,sep=""),append=FALSE)
    print(design.table,type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(fm1.table,type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(fm2.table,type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(anova(fm2)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(anova(fm2b,fm2)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(fm3.table,type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(anova(fm3)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(npk.aov),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(anova(npk.aov)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(summary(npk.aov)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(npk.aovE),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(summary(npk.aovE)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    if(i=="latex") cat("\\clearpage\n",file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(lm.D9),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(anova(lm.D9)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(glm.D93),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    print(xtable(anova(glm.D93,test="Chisq")),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    if(require(mva,quietly=TRUE)) {
      print(xtable(pr1),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
      print(xtable(summary(pr1)),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
      print(xtable(pr2),type=i,file=paste("xtable.",i,sep=""),append=TRUE)
    }
  }
 


## Keywords: 'file'.


