"Fbenergy"<-
function(crds)
{
# Function to compute the bending energy matrix for thin-plate spline
# mappings of the coordinates in the nx2 matrix crds.
# Follow notation of Mardia, Kent & Walder, 1991.
	n <- nrow(crds)
	Dist2 <- Fdist(crds)^2
	Sig <- Dist2 * log(Dist2)
	Sig[row(Sig) == col(Sig)] <- 0
	Tc <- t(cbind(1, crds))
	P <- t(Tc) %*% solve(Tc %*% t(Tc)) %*% Tc
	IP <- diag(n) - P
	B1 <- IP %*% Sig %*% IP
	B <- FMPinv(B1)
	B
}
