"met.s"<-
function(cx, cy, theta = 0, flag = 1, fill = 0, cex = 2)
{
	tpar <- par()
	size <- tpar$csi
	scalex <- (tpar$usr[2] - tpar$usr[1])/(tpar$pin[1])
	scaley <- (tpar$usr[4] - tpar$usr[3])/(tpar$pin[2])	#
# these scales are the length of a inch in the users coordinates of
# the plot
#
#  the base circle of symbol will be the size of the
# O character 
#
# divided by 5  because symbols are defined on a ragne -5,5 to make it
# easy to read. 
#
	scalex <- (cex * (scalex * size))/5
	scaley <- (cex * (scaley * size))/5
	xs <- if(flag > 0) {
		if(flag == 1) {
			X1 <- 0
			X2 <- 0
			Y1 <- 0 + 1
			Y2 <- 4 + 1
		}
		if(flag == 2) {
			X1 <- c(0, 0)
			X2 <- c(0, 1)
			Y1 <- c(0, 3) + 1
			Y2 <- c(4, 3) + 1
		}
		if(flag == 3) {
			X1 <- c(0, 0)
			X2 <- c(0, 2)
			Y1 <- c(0, 4) + 1
			Y2 <- c(4, 4) + 1
		}
		if(flag == 4) {
			X1 <- c(0, 0, 0)
			X2 <- c(0, 1, 2)
			Y1 <- c(0, 3, 4) + 1
			Y2 <- c(4, 3, 4) + 1
		}
		if(flag == 5) {
			X1 <- c(0, 0, 0)
			X2 <- c(0, 2, 2)
			Y1 <- c(0, 3, 4) + 1
			Y2 <- c(4, 3, 4) + 1
		}
### tranform flag
		theta <- (theta/360) * 2 * pi
		rot <- cbind(c(cos(theta),  - sin(theta)), c(sin(theta), cos(
			theta)))
		S1 <- rbind(X1, Y1)
		S2 <- rbind(X2, Y2)
		S1 <- rot %*% S1
		S2 <- rot %*% S2
		S1 <- S1 * c(scalex, scaley) + c(cx, cy)
		S2 <- S2 * c(scalex, scaley) + c(cx, cy)
	}
	if(flag > 0) {
		segments(S1[1,  ], S1[2,  ], S2[1,  ], S2[2,  ])
	}
# make circle
	ts <- seq(0, 2 * pi,  , 200)
	RX <- sin(ts) * scalex
	X1 <- RX + cx
	RY <- cos(ts) * scaley
	Y1 <- RY + cy
	if(flag == 0) {
		lines(RX * 2 + cx, RY * 2 + cy)
	}
# fill center with amount of cloud cover
	if(fill > 0) {
		lim <- c(51, 101, 151, 200)
		polygon(c(cx, X1[1:lim[fill]]), c(cy, Y1[1:lim[fill]]), density
			 = -1)
	}
#  draw circle
#
	lines(RX + cx, RY + cy)
	invisible()
}
