"pairs.funfits"<-
function(x, labels = names(x), panel = points, grid, minlength = c(4, 7), 
	invert = TRUE, ...)
{
	n <- ncol(x)
	for(i in seq(n))
		if(is.matrix(x[[i]])) {
			x <- xpdmat.data.frame(x)
			n <- ncol(x)
		}
	doaxis <- function(which, axp, visible, labels, srt)
	{
		if(visible && !is.null(labels))
			visible <- labels
		at <- if(!is.null(labels)) seq(axp[1] + 1, axp[2] - 1, length
				 = length(labels)) else seq(axp[1], axp[2], 
				length = axp[3] + 1)
		axis(which, at = round(at, dig = 3), outer = T, line = -0.5, 
			labels = visible, srt = srt)
	}
	dolabel <- if(is.vector(minlength) && length(minlength) == 2) function(
			x, minlength)
		abbreviate(x, minlength = minlength) else stop(
			"bad argument for abbreviate")
	if(is.character(panel))
		panel <- get(panel, mode = "function")
	xrange <- axis.labels <- list()
	for(i in seq(n)) {
		X <- c(x[, i], grid[, i])
		if(is.factor(X)) {
			x[, i] <- I(category(X, exclude = if(any(is.na(X))) NA
				 else NULL))
			axis.labels[[i]] <- dolabel(levels(x[, i]), minlength)
			xrange[[i]] <- c(0, max(c(x[, i], grid[, i]), na.rm = T
				) + 1)
		}
		else xrange[[i]] <- range(X, na.rm = T)
	}
	oldpar <- par("oma", "mar", "cex", "tck", "mfg", "mgp", "mex", "mfrow")
	oldcex <- par("cex")
	CEX <- oldcex * max(7.7000000000000002/(2 * n + 3), 0.59999999999999998
		)
	par(mfrow = c(n, n), mgp = c(2, 0.80000000000000004, 0), oma = rep(3, 4
		), mar = rep(0.5, 4), tck = -0.029999999999999999/n)
	on.exit({
		par(oldpar)
	}
	)
	par(cex = CEX)
	if(length(labels) < n)
		labels <- paste(deparse(substitute(x)), "[,", 1:n, "]", sep = 
			"")
	if(par("pty") == "s") {
		dif <- diff(par("fin"))/2
		if(dif > 0)
			par(omi = c(dif * n, 0, dif * n, 0) + par("omi"))
		else par(omi = c(0, ( - dif) * n, 0, ( - dif) * n) + par("omi")
				)
	}
	order <- if(invert) 1:n else n:1
	for(i in order) {
		for(j in 1:n) {
			.S(plot(xrange[[j]], xrange[[i]], type = "n", axes = F, 
				...), "plot")
			box()
			if(i == 1)
				doaxis(3, par("xaxp"), j %% 2 == 0, axis.labels[[
				  j]], 0)
			if(i == n)
				doaxis(1, par("xaxp"), j %% 2 == 1, axis.labels[[
				  j]], 0)
			if(j == 1)
				doaxis(2, par("yaxp"), i %% 2 == 0, axis.labels[[
				  i]], 90)
			if(j == n)
				doaxis(4, par("yaxp"), i %% 2 == 1, axis.labels[[
				  i]], 90)
			if(i != j)
				panel(as.vector(x[, j]), as.vector(x[, i]), i
				   = i, j = j, grid = grid, ...)
			else {
				par(usr = c(0, 1, 0, 1))
				text(0.5, 0.5, labels[i], cex = 1.5 * CEX)
			}
		}
	}
	invisible()
}
