"plot.map.cov"<-
function(obj, tcex = 0.80000000000000004, which = c(T, T, T, T, T, T), nx = 15, 
	ny = 15, graphics.reset = T)
{
	old.par <- par("mfrow", "oma")
	if(graphics.reset) {
		on.exit(par(old.par))
		par(xpd = T)
	}
	set.panel(3, 2, relax = T)
	xr <- range(obj$loc[, 1])
	yr <- range(obj$loc[, 2])
	upper <- col(obj$cor) > row(obj$cor)
	if(which[1]) {
		plot(rdist(obj$loc, obj$loc)[upper], obj$cor[upper], xlab = 
			"distance geographic\nspace", ylab = "correlation", 
			ylim = c(0, 1))
	}
	if(which[2]) {
		rd <- rdist(obj$Dplane.loc, obj$Dplane.loc)[upper]
		plot(rd, obj$cor[upper], xlab = "distance in\nUV space", ylab
			 = "correlation", ylim = c(0, 1))
		points(rd, map.cov(obj$loc, data = obj, cor = T)[upper], pch = 
			".")	#
	}
#
#
	if(which[3]) {
		out.p <- predict.surface(obj$mean.obj)
		surface(out.p, type = "I")
		points(obj$loc)
		title("Mean")
	}
	if(which[4]) {
		out.p <- predict.surface(obj$sd.obj)
		surface(out.p, type = "I")
		points(obj$loc)
		title(" Marginal SD")
	}
#
#
	if(which[5]) {
		plot(obj$loc, xlab = "X", ylab = "Y")
		points(obj$loc[obj$sitesfix,  ], pch = ".")
		loc.id <- dimnames(obj$loc)[[1]]
		if(!is.null(loc.id))
			text(obj$loc, loc.id, cex = tcex, adj = 0)
		xg <- seq(xr[1], xr[2],  , nx)
		yg <- seq(yr[1], yr[2],  , ny)
		matlines(xg, matrix(yg, nx, ny, byrow = T), lty = 2, col = 1)
		matlines(matrix(xg, ny, nx, byrow = T), yg, lty = 2, col = 1)	#
# now do the trasnformed  coordinates
#
	}
	if(which[6]) {
		xy <- cbind(rep(xg, ny), rep(yg, rep(nx, ny)))
		uv <- predict(obj$map.obj, xy)
		plot(obj$Dplane.loc, xlim = range(uv[, 1]), ylim = range(uv[, 2
			]), xlab = "U", ylab = "V")
		points(obj$Dplane.loc[obj$sitesfix,  ], pch = "O")
		if(!is.null(loc.id))
			text(obj$Dplane.loc, loc.id, cex = tcex, adj = 0)
		matlines(matrix(uv[, 1], nx, ny, byrow = T), matrix(uv[, 2], nx,
			ny, byrow = T), lty = 2, col = 1)
		matlines(t(matrix(uv[, 1], nx, ny, byrow = T)), t(matrix(uv[, 2
			], nx, ny, byrow = T)), lty = 2, col = 1)
	}
}
