"plot.sreg"<-
function(out, pch = ".", main = NA)
{
	old.par <- par("mfrow", "oma")
	on.exit(par(old.par))
	par(mfrow = c(2, 2), pch = pch)
	plot(out$x, out$y, xlab = "X", ylab = "y")
	orderx <- order(out$x)
	matlines(out$x[orderx], out$fitted.values[orderx,  ], lty = 1, col = 1)
	for(k in (1:length(out$lambda))) {
		plot(out$fitted.values[, k], out$residuals[, k], ylab = 
			"residuals", xlab = " predicted values")
	}
	if(nrow(out$gcv.grid) > 1) {
# trim off + infinity due to pole in the denominator of GCV function
#with cost
		ind <- out$gcv.grid[, 3] < 1e+19
		out$gcv.grid <- out$gcv.grid[ind,  ]
		plot(out$gcv.grid[, 2], (out$gcv.grid[, 3]), xlab = 
			"Effective number of parameters", ylab = 
			" estimated (EASE) + sigma**2 ", pch = ".")
		title(" Estimated Average Squared Prediction Error", cex = 0.5)
	}
	if(is.na(main))
		mtext(deparse(out$call), cex = 1.3, outer = T, line = -2)
	else mtext(main, cex = 1.3, outer = T, line = -2)
}
