"print.summary.tps"<-
function(x, ...)
{
## pdh 11/25/96 -- uses r.square if available
	digits <- x$digits
	c1 <- "Number of Observations:"
	c2 <- x$num.observation
	c1 <- c(c1, "Degree of polynomial null space ( base model):")
	c2 <- c(c2, x$m - 1)
	c1 <- c(c1, "Number of parameters in the null space")
	c2 <- c(c2, x$nt)
	c1 <- c(c1, "Effective degrees of freedom:")
	c2 <- c(c2, format(round(x$enp, 1)))
	c1 <- c(c1, "Residual degrees of freedom:")
	c2 <- c(c2, format(round(x$num.observation - x$enp, 1)))
	c1 <- c(c1, "Root Mean Square Error:")
	c2 <- c(c2, format(signif(x$shat, digits)))
	if(!is.null(x$pure.error)) {
		c1 <- c(c1, "Pure Error:")
		c2 <- c(c2, format(round(x$pure.error, digits)))	
	##      c1 <- c(c1,'DF Pure Error:')
##      c2 <- c(c2,x$pure.df)
	}
	if(!is.null(x$press)) {
		c1 <- c(c1, "RMSE (PRESS):")
		c2 <- c(c2, format(round(x$rmse.press, digits)))
	}
	c1 <- c(c1, "GCV (Prediction error)")
	c2 <- c(c2, format(signif(x$gcv.rmse, digits)))
	if(!is.null(x$r.square)) {
		c1 <- c(c1, "Mutiple R-squared:")
		c2 <- c(c2, format(signif(x$r.square, digits)))
	}
	else if(!is.null(x$covariance)) {
		c1 <- c(c1, "Mutiple R-squared:")
		c2 <- c(c2, format(signif(x$covariance, digits)))
	}
	c1 <- c(c1, "Adjusted R-squared:")
	c2 <- c(c2, format(signif(x$adjr2, digits)))
	if(!is.null(x$q2)) {
		c1 <- c(c1, "Q-squared:")
		c2 <- c(c2, format(round(x$q2, 4)))
	}
	if(!is.null(x$press)) {
		c1 <- c(c1, "PRESS:")
		c2 <- c(c2, format(round(x$press, digits)))
	}
	c1 <- c(c1, "Log10(lambda):")
	c2 <- c(c2, format(round(log10(x$lambda), 4)))
	c1 <- c(c1, "m, power, d, cost:")
	c2 <- c(c2, paste(x$m, format(round(x$power, 1)), x$d, format(round(x$
		cost, 2)), sep = ", "))
	sum <- cbind(c1, c2)
	dimnames(sum) <- list(rep("", dim(sum)[1]), rep("", dim(sum)[2]))
	res.quantile <- x$res.quantile
	names(res.quantile) <- c("min", "1st Q", "median", "3rd Q", "max")
	cat("Call:\n")
	dput(x$call)
	print(sum, quote = F)
	cat(" Residuals:", "\n")
	print(signif(res.quantile, digits))
	if(x$form == 0) {
		print("Warning: Model is not a thin plate spline")
	}
	cat(" Method for specifying the smoothing parameter is ", x$method, 
		fill = T)
	invisible(x)
}
