"rowmatch"<-
function(xmat1, xmat2, digits = 8)
{
## find which rows in xmat2 the rows in xmat1 correspond to
##
## pdh 1/8/97 - reversed roles of xmat1 and xmat2 to make the
##    call more consistent with functions such as charmatch
## pdh 1/7/97 - fixed so that NAs are returned in case of no match
## pdh 1/6/97 - found another error. should have been searching
##   for uniques values in xmatt and xmat1 combined
## pdh 12/20/96 -- added digits, rewrote to work properly
	xmat2 <- as.matrix(xmat2)	
	## check to be sure there are not duplicates before proceding
## otherwise ambiguous matches will occur
	if(any(dup.matrix(xmat2)))
		stop("Error: xmat2 has duplicate rows.")
	xmat1 <- as.matrix(xmat1)
	xmat <- rbind(xmat2, xmat1)
	sel2 <- 1:nrow(xmat2)
	sel1 <- (nrow(xmat2) + 1):nrow(xmat)
	nc1 <- ncol(xmat)
	temp1 <- matrix(match(c(round(xmat, digits)), unique(c(round(xmat, 
		digits)))), ncol = nc1)
	temp1b <- format(temp1[, 1])
	if(nc1 > 1) {
		for(k in 2:nc1) {
			temp1b <- paste(temp1b, temp1[, k], sep = "X")
		}
	}
	temp2b <- temp1b[sel2]
	temp1b <- temp1b[sel1]
	out <- charmatch(temp1b, temp2b)	## now replace any nonmatches with NAs
	out[out > nrow(xmat2)] <- NA
	out
}
