\name{arrow.plot}
\alias{arrow.plot}
\title{
Plots a vector field
}
\description{
Draws arrows at specified points the arrow lengths are scaled to fit on
the plot in a reasonable manner. The classic use of this plot is to depict
a vector field. The direction an length of the arrows is given as a
vector. 
}
\usage{
arrow.plot(a1, a2, u=NA, v=NA, arrow.ex=0.05, add=F, size=0.2, open=T, rel=T, xpd=T, true.angle=F, col=1, \dots)
}
\arguments{
\item{a1}{
The x locations of the tails of the arrows _or_ a matrix giving
the x and y coordinates of the arrow tails.
}
\item{a2}{
The y locations of the tails of the arrows _or_ a matrix giving 
the u and v coordinates of the arrows.
}
\item{u}{
The u components of the direction vectors if they are not specified in
the a2 argument
}
\item{v}{
The v  components of the direction vectors if they are not specified in    
the a2 argument
}
\item{arrow.ex}{
Controls the length of the arrows. The length is in terms of the fraction
of the shorter axis in the plot. So with a default of .05 20 arrows 
of maximum length can 
line up end to end along the shorter axis.  
}
\item{add}{
If true add arrows to existing plot. 
}
\item{size,}{
These are options passed through to the arrows function see the help
file on arrows to figure these out!
}
\item{xpd}{
If true does not clip to arrows to fit inside the plot region, default is
not to clip.
}
\item{true.angle}{
If true preserves the true angle of the (u,v) pair on the plot. E.g. if 
(u,v)=(1,1) then the arrow will be drawn at 45 degrees. 
}
\item{col}{
Color of the arrows
}
\item{...}{
Graphics arguments passed to the plot function that sets up the the axes and
plto region. Only matters if add=F ( the default)
}}
\details{
The only tricky thing about this function is whether you want the true
angles on the plot. For overlaying a  vector field on top of contours
that are the streamlines  true.angle should be false. In this case you
want u and v to be scaled in the same way as the x and y variables. 
If the scaling is not the same then the arrows will not look like tangent
vectors to the streamlines. 
For an application where the absolute angles are meaningful e.g hands of a
clock showing different times zones on a map true.angle=T. You do not want
the clock hands scaled the same as longitude and latitude!


}
\seealso{
arrows
}
\examples{






# lines of force between two positive charges at (-2,0) and (2,0)


seq( -3,3,,40)->x
make.surface.grid( list( x,x))-> xg
# distances to the two charges 
dP1<-sqrt((xg[,1]-2)**2 + xg[,2]**2)
dP2<-sqrt((xg[,1]+2 )**2 + xg[,2]**2) 


pot<- 1/dP1 + 1/dP2  # electrostatic potential
as.surface( xg,pot)-> out
image( out)
contour( out, nlevels=10, labex=0, add=T) # plot of potential function


u<- -(1/2)*(xg[,1]- 2)/ dP1**(3/2)  + -(1/2)*(xg[,1]+ 2)/ dP2**(3/2)
v<- xg[,2] *( 1/dP1**(3/2) + 1/dP2**(3/2))
arrow.plot( xg, cbind( u,v), add=T)  # vector field showing
forces




}
\keyword{FUNFITS}
% Converted by Sd2Rd version 0.3-2.
