\name{image.plot}
\alias{image.plot}
\title{
Draws image plot with a legend for the color scale. 
}
\description{
This function combines the SPLUS image function with some automatic
placement of a legend. This is done by splitting the plotting region 
into two parts. Putting the image in one and the legend in the other. 
}
\usage{
image.plot(\dots, nlevel=32, legend.shrink=0.9, legend.width=0.02, 
graphics.reset=T, horizontal=F, offset=0.04, 
bigplot=NULL, smallplot=NULL, legend.only=F)


}
\arguments{
\item{...}{
The usual arguments to the image function. But in this context add=T does
not make sense since these functions may change the size of the plotting
region. 
}
\item{nlevel}{
Number of color levels used in legend strip 
}
\item{legend.shrink}{
 Amount to shrink the size of legend relative to teh full height or widht 
of the plot. 
}
\item{legend.width}{
Width in plot coordinates of the legend strip
}
\item{graphics.reset}{
If true (default) will reset plot parameters  to the values before 
entering the function. If false plot coordinates are not reste and thus 
one can can more information onto the image plot
}
\item{horizontal}{
If false (default) legend will be a vertical strip on the right side. 
}
\item{bigplot}{
Plot coordinates for image plot
}
\item{small}{
Plot coordinates for legend 
}
\item{legend.only}{
If true  only put the legend in the box defined by the coordinates in 
smallplot. 




}}
\section{Side Effects}{
After exiting the plotting region is reset to the values before using the 
function and the user coordinates are scaled so that one can add more
features to the plot. 
}
\details{


All plotting coordinates mentioned here are in device coordinates. The
figure region is assumed to be [0,1]X[0,1] and plotting regions are
defined as rectangles within this square. We found these easier to think
about than user coordinates. 


There are always problems with default solutions to placing information on
graphs but the choices made here may be useful for most cases. 
The
strategy is simple, divide the plotting region into two smaller regions. 
The image goes in one and the legend in the other. This way there is always
room for the legend. Some adjustments are made to this rule by not 
shrinking the image plot if there is already room for the legend strip and
also sticking the legend strip close to the image plot. 


There may be problems with small plotting regions in
fitting both of these plot and one may have to change the default character
sizes or margins to make things fit. By keeping the zlim argument the same
across images one can generate the same color scale. (See image help file) 
Part of the motivation was some more control over the legend plot and this
possible because plotting the legend is a clearly delineated step in this
function. 


}
\seealso{
image
}
\examples{
 x<- 1:10
 y<- 1:15
z<- outer( x,y,"+")
image.plot(x,y,z)


# now add some points on diagonal 


image.plot(x,y,z, graphics.reset=T)
points( 1:10, 1:10)






}
\keyword{FUNFITS}
% Converted by Sd2Rd version 0.3-2.
