"as.KERNEL.cov"<-
function(theta = 161, rho = 0.5, M = 5, num = 10)
{
# find difference between correlation matrix and that estimated by
# isotropic exponential model. 
#
# correlation matrix computed with 2d fft
#
#	work.mat <- cor.mat - rho * make.exp.cor(loc, theta = theta)
#	temp <- test.fn(work.mat, M, num = 25)
#
	theta.temp <- theta/(c(52.24174, 69.184030000000007))
	a <- ncol(great.lakes.8av)
	Q0 <- matrix(runif(a * M), nrow = a, ncol = M)
	Q0 <- qr.Q(qr(Q0))	#	
# set up isotropic covariance matrix for fft routine
#
	cov.mat.grid <- cbind(seq(0.25, 32, 0.25), seq(1/6, 128/6, 1/6))
	tmp <- outer(((cov.mat.grid[64, 1] - cov.mat.grid[, 1])/theta.temp[1])^
		2, ((cov.mat.grid[64, 2] - cov.mat.grid[, 2])/theta.temp[2])^2, 
		FUN = "+")
	cov.mat <- exp( - sqrt(tmp))
	cov.mat.fft <- fft(cov.mat)	#
# some scratch arrays
	W <- matrix(0, 128, 128)
	W[64, 64] <- 1
	W.fft <- fft(W)
	tmp <- matrix(0, 128, 128)	#
# begin subspace iteration for eigenvalues-eigenvectors
	for(count in 1:num) {
#               Q0 <- qr.Q(qr(A %*% Q0))
		Q1 <- Q0
		for(i in (1:M)) {
			tmp[1:48, 1:51] <- as.surface.rom(Q0[, i])$z
			Qi.mat.fft <- fft(tmp)
			tmp2 <- fft((cov.mat.fft * Qi.mat.fft)/W.fft, inverse
				 = T)
			Q1[, i] <- Re(as.vector(tmp2[1:48, 1:51]))/128^2
		}
		out <- qr(t(great.lakes.std) %*% (great.lakes.std %*% Q0)/(88) - 
			rho * Q1)
		Q0 <- qr.Q(out)
		R <- qr.R(out)	#               print(Q0)
		cat(" iteration ", count, fill = T)
		print(diag(R))
		converge <- sum(abs(R[col(R) > row(R)])) < 
			1.0000000000000001e-05
		if(converge)
			break
	}
	U <- Q0	#
##
# find the rank of the smallest eigenvalue that is negative
#	print(U)	
# if it less than M stop !
# figure out when the first negative eignavalue occurs when they are
#sorted in decending order by absolute value
	temp.e <- diag(R)	#	temp.e <- temp.e[order( - abs(temp.e))]
	print(temp.e)
	M.neg <- min((1:length(temp.e))[temp.e < 0], M + 1)	#		#		fixed, pls
###	cat(" first eigenvalue", temp$values[1], fill = T)
	cat(" first eigenvalue", temp.e[1], fill = T)
	cat("first negative is the ", M.neg, "th largest in abs. value =", 
		temp.e[M.neg], fill = T)	##
###
	if(M.neg <= M) {
		M <- M.neg - 1
		warning(" Some negaitve eigenvalues found! M has been reset ")
	}
###
	fits <- as.list(1:M)
	for(k in 1:M) {
		fits[[k]] <- as.surface.rom(U[, k])$z
	}
#        Now make up weights 
	temp.e <- temp.e[1:M]
	temp.w <- c(rho + U[, 1:M]^2 %*% temp.e)
	fit.wght <- gl.sd/sqrt(temp.w)
	call <- match.call()
	list(loc = great.lakes.rom.grid, delta = temp.e, fits = fits, fit.wght
		 = fit.wght, sigma = as.surface.rom(gl.sd)$z, rho = rho, U = U, 
		theta.exp = theta.temp, M = M, call = call)
}
