"as.map.cov"<-
function(cov.mat, loc, mean.loc = NULL, scalingloc = 1, cov = "exp", start = c(
	0.20000000000000001, 0.20000000000000001), lambda = 1, sitesfix = NULL, 
	just.read = F, marginal.method = "tps", mean.obj = NULL, ...)
{
#
# number of observations
#
	n <- nrow(loc)	#
#  Find two reason fixed points: 
#  The one closest to the center of mass and the other the  farthest  away 	
#
	if(is.null(sitesfix)) {
		dcenter <- sqrt(((loc[, 1]) - mean(loc[, 1]))^2 + ((loc[, 1]) - 
			mean(loc[, 1]))^2)
		sitesfix <- order(dcenter)[c(1, n)]
	}
#
# add row and col names if they are missing. 
#
	if(length(dimnames(loc)) != 2) {
		dimnames(loc) <- list(format(1:nrow(loc)), c("x", "y"))
	}
	if(length(dimnames(loc)[[1]]) == 0) {
		dimnames(loc)[[1]] <- format(1:nrow(loc))
	}
	if(length(dimnames(loc)[[2]]) == 0) {
		dimnames(loc)[[2]] <- c("x", "y")
	}
#
# fit marginal standard deviations
#
	mar.sd <- sqrt(diag(cov.mat))
	corrmat <- t(cov.mat/mar.sd)/mar.sd
	sd.obj <- get(marginal.method)(loc, mar.sd, return.matrices = F)	#
# fit mean field if it has not been supplied
#
	if(is.null(mean.obj)) mean.obj <- get(marginal.method)(loc, mean.loc, 
			return.matrices = F)	# CALL to map estimation program
#
	variog <- cov
	if(cov == "exp") variog <- "Exp"	#
# call to estimateion program
#
	temp <- fn.deform.estparam(corrmat = corrmat, geogsiteloc = loc, 
		sta.names = dimnames(loc)[[1]], scalingloc = scalingloc, variog
		 = variog, initvariogpar = start, lamBE.S = lambda, sitesfix = 
		sitesfix, bindir = BIN, just.read = just.read)	#
	print(names(temp))	#
#build covariance function for evaluation
#
	if(cov == "exp") {
		cov.function <- exp.isocor
		cov.function$alpha <- 1	
	#		cov.function$alpha <- 1 - 0.5 * temp$Dplane.variogpar[1]
		rho <- 1 - 0.5 * temp$Dplane.variogpar[1]
		cov.function$theta <- 1/temp$Dplane.variogpar[2]
		vtitle <- "Exponential"
	}
	temp2 <- list()
	class(temp2) <- c("map.cov", "funfits")
	temp2$sd.obj <- sd.obj
	temp2$mean.loc <- mean.loc
	temp2$mean.obj <- mean.obj
	temp2$cov.function <- cov.function
	temp2$rho <- rho
	temp2$lambda <- (1 - rho)/rho
	temp2$sigma2 <- 1 - rho
	temp2$vtitle <- vtitle
	temp2$call <- match.call()
	temp2$deform.estparam <- temp
	temp2$loc <- loc
	temp2$Dplane.loc <- temp$Dplane.crds
	temp2$map.obj <- as.function.map(loc, temp2$Dplane.loc,  , 
		return.matrices = F)
	temp2$sitesfix <- sitesfix
	temp2$cor <- corrmat	#	print(names(temp2))
	temp2
}
