"bubble"<-
function(cov.function = EXP.cov, pr = c(0.90000000000000002), nx = 5, ny = 5, 
	xlim, ylim, center.grid, ...)
{
###  crude test whether covaraince is stationary based on if marginal
### argument is absent i the fucntion call
	stationary <- is.null(cov.function$marginal)
	if(missing(xlim))
		xlim <- par()$usr[1:2]
	if(missing(ylim))
		ylim <- par()$usr[3:4]
	xyg <- make.surface.grid(list(xlim, ylim), nx = 80, ny = 80)
	temp1 <- list(xlim, ylim)
	if(missing(center.grid))
		center.grid <- make.surface.grid(temp1, nx = nx, ny = ny)
	q <- length(center.grid[, 1])	######
	points(center.grid)	
	##### get marginal standard devaitions for the grid points
	if(stationary) {
		s1 <- sqrt(cov.function(xyg[1:2,  ], xyg[1:2,  ], ...)[1, 1])
		sq <- rep(s1, q)
	}
	else {
		s1 <- sqrt(cov.function(xyg, marginal = T, ...))
		sq <- sqrt(cov.function(center.grid, marginal = T, ...))
	}
	for(k in 1:q) {
		z <- c(cov.function(xyg, cbind(center.grid[k, 1], center.grid[k,
			2]), ...))
		z <- z/(s1 * sq[k])
		contour(as.surface(xyg, z), levels = pr, add = T, labex = 0)
	}
#	return(xyg, s1, center.grid, sq)
	invisible()
}
