"pareto.tps"<-
function(tps.object, sig = 0.050000000000000003, prt.values = T, shade = F, ...,
	xlab, main, col = c(1, 6, 3), dens = c(10, 60), mar = c(5, 11, 4, 2) + 
	0.10000000000000001)
{
	digits <- 3
	out <- tps.parm(tps.object)
	tval <- out$tstat[-1]	#tvalues
	enames <- row.names(out)[-1]
	ordef <- order(abs(tval))
	degf <- dim(tps.object$x)[1] - tps.object$eff.df
	sig.level <- qt(1 - sig/2, degf)
	attr(sig.level, "sig") <- sig
	xmax <- max(abs(tval), sig.level)
	plot.info <- c(dim(tps.object$x)[1], degf, tps.object$shat)	
	###########################################################################
### now do the pareto chart
	if(missing(xlab))
		xlab <- "t-values of Coefficients"
	if(missing(main)) main <- deparse(tps.object$call)	
	#main <- paste("Pareto Plot for", tps.object$call)
	pareto.plus(tval, enames, xmax = xmax, sigline = sig.level, prt.values
		 = prt.values, shade = shade, xlab = xlab, main = main, col = 
		col, dens = dens, plot.info = plot.info, mar = mar, ...)
	invisible()
}
