"plot.window"<-
function(screen.name)
{
	plt <- T
	look <- getenv("DISPLAY")
	if((look == "") & missing(screen.name)) {
		cat("Remember that you can not do graphics from a terminal \nwindow ",
			"\n You may need to set the DISPLAY\nenvironment variable on the machine that is running Splus.",
			fill = T)
		plt <- F
		return(F)
	}
	if(plt) {
# begin setup for open look window 
		cat(" Trying to open a motif style plot window on your screen ...",
			fill = T)
		if(missing(screen.name))
			screen.name <- look
		cat("S thinks that the name of your screen is", screen.name, 
			fill = T)
		motif(c(.motif.options, paste("-d ", screen.name)))
		return(T)
	}
	invisible()
}
