"sort.matrix"<-
function(x, byrow = F)
{
	if(!is.loaded(symbol.For("msort"))) {
		temp <- dyn.load.shared(paste(FUNFITS.BIN, "funfits.so", sep = 
			""), 2)
	}
	n <- as.integer(ncol(x))
	m <- as.integer(nrow(x))
	if(!byrow) {
		return(matrix(.Fortran("msort",
			m,
			n,
			as.double(x))[[3]], ncol = n))
	}
	else {
		return(t(matrix(.Fortran("msort",
			n,
			m,
			as.double(t(x)))[[3]], ncol = m)))
	}
}
