"tps.all.poss"<-
function(xmat, y, m.try = 1, tps.cost = 2, knot.add = NULL, onevars = F)
{
	nvar <- dim(xmat)[[2]]
	all.poss.mat <- gen.all.poss(nvar)
	if(onevars)
		all.poss.mat <- all.poss.mat[1:(2^(nvar) - 1),  ]
	else all.poss.mat <- all.poss.mat[apply(all.poss.mat, 1, function(x)
		length(x[x != 0])) > 1,  ]
	ndesigns <- dim(all.poss.mat)[[1]]
	gcvmin <- eff.df <- rmse <- rsq <- q2 <- rep(NA, ndesigns)
	for(i in 1:ndesigns) {
		print(i)
		xcols <- (1:nvar)[all.poss.mat[i,  ] != 0]
		x <- xmat[, xcols]
		if(length(xcols) > qr(x)$rank) {
			print("attempted less than full-rank matrix with")
			print(xcols)
		}
		if(!is.null(knot.add)) {
#if supplying knot.add, it should be a vector of 1's and 0's indicating which x points should be used as knots
			if(is.null(dim(x))) knot.try <- x[knot.add == 1] else 
				  knot.try <- x[knot.add == 1,  ]
			out <- tps(x, y, m = m.try, print.warning = F, cost = 
				tps.cost, knots = knot.try)
		}
		else out <- mytps(x, y, m = m.try, print.warning = F, cost = 
				tps.cost)
		gcvmin[i] <- ifelse(is.null(out$GCV), NA, out$GCV)
		eff.df[i] <- ifelse(is.null(out$eff.df), NA, out$eff.df)
		rmse[i] <- ifelse(is.null(out$shat), NA, out$shat)
		rsq[i] <- r2(out)
		q2[i] <- ifelse(is.null(out$q2), NA, out$q2)
	}
	list(all.poss.mat = all.poss.mat, stats = cbind(gcvmin, eff.df, rmse, 
		q2, rsq))
}
