kdesign.cenum <- function(point.obj,
                     eligible.obj,
                     ns,
                     at,
                     var.mod.obj,
                     xsw=NULL,ysw=NULL,xne=NULL,yne=NULL,
                     dx=NULL,dy=NULL,
                     angle=NULL,
                     maxdist = NULL,
                     extrap = FALSE,
                     border=NULL,
                     trend=0,
                     rsearch=0,
                     nsearch=0,
                     nsmin=-1,
                     nsmax=-1,
                     pgrid=1,
                     verbose=FALSE,
                     criterion="meanvar")
  {
    mode<-2
    extcov<-1
    verbose<-verbose*1
    if(is.null(angle)) angle<-0
    if(pgrid==1)
      {
        if(is.null(xsw)) xsw<-min(point.obj$x,eligible.obj$x)
        if(is.null(xne)) xne<-max(point.obj$x,eligible.obj$x)
        if(is.null(ysw)) ysw<-min(point.obj$y,eligible.obj$y)
        if(is.null(yne)) yne<-max(point.obj$y,eligible.obj$y)
      }
    if(pgrid==2)
      {
        if(is.null(xsw)) xsw<-min(eligible.obj$x)
        if(is.null(xne)) xne<-max(eligible.obj$x)
        if(is.null(ysw)) ysw<-min(eligible.obj$y)
        if(is.null(yne)) yne<-max(eligible.obj$y)
      }

    testcriterion <- switch(criterion, meanvar="ok",maxvar="ok","error")
    if(testcriterion=="error")
      stop("wrong argument for \"criterion\", should be one of \"meanvar\", \"maxvar\"!")
    
    dgx <- xne-xsw
    dgy <- yne-ysw

    if(is.null(dx)) dx <- dgx/20
    if(is.null(dy)) dy <- dgy/20

    nx <- ceiling(dgx/dx)+1
    ny <- ceiling(dgy/dy)+1
    
    at <- point.obj[[match(at, names(point.obj))]]
    nf <- length(point.obj$x)
    ne <- length(eligible.obj$x)
    n <- nf+ne

    nz <- nx * ny
    
    dog <- matrix(1, nx, ny)
    if (!extrap) {
      if(pgrid==1)
        {
          tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),
                          sort(rep(seq(ysw,yne,length=ny),nx)))
          dog <- in.chull(tmpgrd[,1], tmpgrd[,2],
                          c(point.obj$x,eligible.obj$x),
                          c(point.obj$y,eligible.obj$y))
        }
      if(pgrid==2)
        {
          tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),
                          sort(rep(seq(ysw,yne,length=ny),nx)))
          dog <- in.chull(tmpgrd[,1], tmpgrd[,2],
                          eligible.obj$x,eligible.obj$y)
        }
     if(!is.null(border)){
     dog2 <- in.polygon(tmpgrd[,1], tmpgrd[,2],
                        border$x,border$y)
     dog <- dog & dog2
     }
      # workaround for int <-> unsigned int problem on alpha platform:
      dog <- abs(as.numeric(dog))
      dog <- matrix(dog, nx, ny,byrow=FALSE)
    }
    
    extrap<-as.integer(1*extrap)
    
    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    c0<-0

    lcov <- matrix(0,n,n)
    
    if(extcov==1)
      {
        P.dist <- as.matrix(dist(rbind(point.obj[,c("x","y")],
                               eligible.obj[,c("x","y")]),diag=TRUE,upper=TRUE))
        A.cov <- var.mod.obj$model(P.dist,var.mod.obj$parameters)
        if(is.na(var.mod.obj$parameters["sill"]))
        C0.cov <- var.mod.obj$parameters["X1"]+var.mod.obj$parameters["X2"]
        else
        C0.cov <- var.mod.obj$parameters["nugget"]+var.mod.obj$parameters["sill"]
        covmat <- C0.cov-A.cov
    }
    
    inde <- (nf+1):n
    ifault <- 1 

    if(criterion=="maxvar")
      {
        ans<-.Fortran("kcemx",
                      nf=as.integer(nf),
                      ne=as.integer(ne),
                      ns=as.integer(ns),
                      S=integer(ne),
                      opt=double(1),
                      ind=integer(n),
                      sind=integer(ns),
                      inde=as.integer(inde),
                      xsw=as.double(xsw),
                      ysw=as.double(ysw),                 
                      xne=as.double(xne),                 
                      yne=as.double(yne),                 
                      angle=as.double(angle),                 
                      nx=as.integer(nx),                 
                      ny=as.integer(ny),                 
                      # nz=as.integer(nz),                 
                      dx=as.double(dx),                 
                      dy=as.double(dy),                 
                      xg=double(nx),                 
                      yg=double(ny),                 
                      zg=double(nz),
                      varg=double(nz),
                      dog=as.integer(dog),
                      lon=as.double(c(point.obj$x,eligible.obj$x)),
                      lat=as.double(c(point.obj$y,eligible.obj$y)),
                      z=double(n),
                      extrap=as.integer(extrap),
                      n=as.integer(n),
                      covtype=as.integer(covtype),
                      covpar=as.double(var.mod.obj$parameters),
                      cov=as.double(covmat),
                      c0vec=double(n),
                      c0=as.double(c0),
                      extcov=as.integer(extcov),
                      trend=as.integer(trend),
                      ntrend=as.integer(ntrend),
                      rsearch=as.double(rsearch),
                      nsearch=as.integer(nsearch),
                      nsmin=as.integer(nsmin),
                      nsmax=as.integer(nsmax),
                      fwork=double(n*ntrend),
                      f0work=double(ntrend),
                      dist=double(n),
                      indsnb=integer(n),
                      indsna=integer(n),
                      indsrt=integer(n),
                      kwork=double((n+ntrend)*(n+ntrend)),
                      nkwork=as.integer(n+ntrend),
                      rhswork=double(n+ntrend),
                      ipiv=integer(n+ntrend),
                      mode=as.integer(mode),
                      mu=double(ntrend),
                      lambda=double(n),            # v-- usesnbbt=0 !            
                      bits=as.integer(c(integer(nz),as.integer(0),integer(n*nz))),
                      ierr=integer(1),
                      lcov=as.double(lcov), 
                      llon=double(n),
                      llat=double(n),
                      ifault=as.integer(ifault),
                      indmax=double(n),
                      verbose=as.integer(verbose))
      }
    else
      {
        ans<-.Fortran("kcemn",
                      nf=as.integer(nf),
                      ne=as.integer(ne),
                      ns=as.integer(ns),
                      S=integer(ne),
                      opt=double(1),
                      ind=integer(n),
                      sind=integer(ns),
                      inde=as.integer(inde),
                      xsw=as.double(xsw),
                      ysw=as.double(ysw),                 
                      xne=as.double(xne),                 
                      yne=as.double(yne),                 
                      angle=as.double(angle),                 
                      nx=as.integer(nx),                 
                      ny=as.integer(ny),                 
                      # nz=as.integer(nz),                 
                      dx=as.double(dx),                 
                      dy=as.double(dy),                 
                      xg=double(nx),                 
                      yg=double(ny),                 
                      zg=double(nz),
                      varg=double(nz),
                      dog=as.integer(dog),
                      lon=as.double(c(point.obj$x,eligible.obj$x)),
                      lat=as.double(c(point.obj$y,eligible.obj$y)),
                      z=double(n),
                      extrap=as.integer(extrap),
                      n=as.integer(n),
                      covtype=as.integer(covtype),
                      covpar=as.double(var.mod.obj$parameters),
                      cov=as.double(covmat),
                      c0vec=double(n),
                      c0=as.double(c0),
                      extcov=as.integer(extcov),
                      trend=as.integer(trend),
                      ntrend=as.integer(ntrend),
                      rsearch=as.double(rsearch),
                      nsearch=as.integer(nsearch),
                      nsmin=as.integer(nsmin),
                      nsmax=as.integer(nsmax),
                      fwork=double(n*ntrend),
                      f0work=double(ntrend),
                      dist=double(n),
                      indsnb=integer(n),
                      indsna=integer(n),
                      indsrt=integer(n),
                      kwork=double((n+ntrend)*(n+ntrend)),
                      nkwork=as.integer(n+ntrend),
                      rhswork=double(n+ntrend),
                      ipiv=integer(n+ntrend),
                      mode=as.integer(mode),
                      mu=double(ntrend),
                      lambda=double(n),            # v-- usesnbbt=0 !            
                      bits=as.integer(c(integer(nz),as.integer(0),integer(n*nz))),
                      ierr=integer(1),
                      lcov=as.double(lcov), 
                      llon=double(n),
                      llat=double(n),
                      ifault=as.integer(ifault),
                      indmean=double(n),
                      verbose=as.integer(verbose))
      }

    retval<-list(x=ans$xg,
                 y=ans$yg,
                 var=matrix(ans$varg,nx,ny),
                 S=ans$sind,
                 opt=ans$opt)

    retval$var[dog==0] <- NA
    retval    
  }

