      SUBROUTINE KGDMN(NF,NE,NS,S,OPT,IND,
     .                  XSW,YSW,XNE,YNE,ANGLE,NX,NY,
     .                  DX,DY,XG,YG,ZG,VARG,DOG,
     .                  LON,LAT,Z,EXTRAP,N,
     .                  COVTYPE,COVPAR,COV,C0,COV0,EXTCOV,TREND,
     .                  NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,FWORK,F0WORK,
     .                  DIST,INDSNB,INDSNA,INDSRT,KWORK,NKWORK,RHSWORK,
     .                  IPIV,MODE,MU,LAMBDA,BITS,
     .                  IERR,LCOV,LLON,LLAT,VERB)

      IMPLICIT NONE
*
*  -- user defined driver routine --   
*     
*
*     .. Scalar Arguments ..
      INTEGER NF, NE, NS, NX, NY, N, VERB,
     .        COVTYPE, EXTCOV, TREND, NTREND, NKWORK,
     .        NSEARCH, NSMIN, NSMAX, MODE, IERR, IPT, EXTRAP
      DOUBLE PRECISION OPT, XSW, YSW, XNE, YNE, ANGLE, DX, DY, RSEARCH
*     .. Array Arguments ..
      INTEGER S(*), IND(*), INDSNB(*), INDSNA(*), INDSRT(*),
     .        IPIV(*),DOG(NX,*),BITS(*)
      DOUBLE PRECISION XG(*), YG(*), ZG(NX,*), VARG(NX,*),
     .                 LON(*), LAT(*), Z(*), COV(N,*), C0(*), COV0(*),
     .                 FWORK(N,*), F0WORK(NTREND,*), DIST(*),
     .                 KWORK(NKWORK,*), RHSWORK(*), MU(*), LAMBDA(*),
     .                 COVPAR(*), LCOV(N,*), LLON(*), LLAT(*)


c     local variables
      INTEGER            I, J, K, L, M, CARDS, JMIN, JMAX,
     .                   NA, COUNT, LDCOV, NI, IKMEAN, RETLM
      DOUBLE PRECISION   KMAX, KMIN, KMINGES, KMEAN
*     ..
*     .. Local Arrays ..
*     ..
*     .. External Functions ..
*     ..
*     .. External Subroutines ..
      EXTERNAL           KRIGE_GRID, PSUBM, PIND
*     ..
*     .. Intrinsic Functions ..
*     ..
*     .. Executable Statements ..
*
*
* Initializing
 
      RETLM=0

      LDCOV=N
      NA=N
      DO 10 I=1,NE
         S(I)=I+NF
 10   CONTINUE

      DO 11 I=1,NF
         IND(I)=I
         LLON(I)=LON(I)
         LLAT(I)=LAT(I)
 11   CONTINUE
      
      DO 12 I=NF+1,NA
         IND(I)=0
         LLON(I)=0
         LLAT(I)=0
 12   CONTINUE
      JMAX=1

* Main loop

 20   CONTINUE

* Computation of the cardinality of the actual solution
 
      CARDS=NF
      DO 21 I=1,NE
         IF (S(I).NE.0) THEN
            CARDS=CARDS+1
         ENDIF
 21   CONTINUE

* Is the actual solution S feasible?

      IF (CARDS.GT.(NF+NS)) THEN 
         GOTO 22
      ELSE
         GOTO 30
      ENDIF
 22   CONTINUE

* Computation of the actual index set IND
 
      K=NF+1
      DO 221 I=JMAX,NE
         IF (S(I).NE.0 .AND. I.NE.JMAX) THEN
            IND(K)=S(I)
            K=K+1
         ENDIF
 221   CONTINUE

* Computation of the maximal krige variance of the actual 
* infeasible solution 

       NI=K-1
       DO 222 L=NF+1,NI
          LLON(L)=LON(IND(L))
          LLAT(L)=LAT(IND(L))
 222   CONTINUE
       CALL PSUBM(COV,NA,NA,LCOV,NA,IND,NI)

      CALL KRIGE_GRID(XSW,YSW,XNE,YNE,ANGLE,NX,NY,
     .     DX,DY,XG,YG,ZG,VARG,DOG,
     .     LLON,LLAT,Z,EXTRAP,NI,
     .     COVTYPE,COVPAR,LCOV,LDCOV,EXTCOV,TREND,
     .     NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,MODE,MU,LAMBDA,BITS,
     .     RETLM,IERR)
            
            KMEAN=0.0D0
            IKMEAN=0
            DO 223 L=1,NX
               DO 224 M=1,NY 
                  IF(DOG(L,M).EQ.1) THEN
                     KMEAN=KMEAN+VARG(L,M)
                     IKMEAN=IKMEAN+1
                  ENDIF
 224              CONTINUE
 223        CONTINUE

            KMINGES=KMEAN/IKMEAN
            JMIN=JMAX

* Selecting a station as candidate to reduce the network
* Computation of the maximum krige variance of the resulting network 

      DO 23 J=JMAX,NE
         IF (S(J) .NE. 0) THEN 
            K=NF+1
            DO 230 I=JMAX,NE
               IF(S(I).NE.0 .AND. I.NE.J) THEN
                  IND(K)=S(I)
                  K=K+1
               ENDIF
 230        CONTINUE
            NI=K-1

            DO 231 L=NF+1,NI
               LLON(L)=LON(IND(L))
               LLAT(L)=LAT(IND(L))
 231        CONTINUE
            CALL PSUBM(COV,NA,NA,LCOV,NA,IND,NI)

      CALL KRIGE_GRID(XSW,YSW,XNE,YNE,ANGLE,NX,NY,
     .     DX,DY,XG,YG,ZG,VARG,DOG,
     .     LLON,LLAT,Z,EXTRAP,NI,
     .     COVTYPE,COVPAR,LCOV,LDCOV,EXTCOV,TREND,
     .     NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,MODE,MU,LAMBDA,BITS,
     .     RETLM,IERR)
            
*     Determining the maximal krige variance for the actual selection 

            KMEAN=0.0D0
            IKMEAN=0
            DO 24 L=1,NX
               DO 25 M=1,NY 
                  IF(DOG(L,M).EQ.1) THEN
                     KMEAN=KMEAN+VARG(L,M)
                     IKMEAN=IKMEAN+1
                  ENDIF
 25            CONTINUE
 24         CONTINUE

            KMEAN=KMEAN/IKMEAN
      if (verb.eq.1) write (*,*) 'no of comb. / mean variance:', count, 
     .    '/', kmean

            IF (KMEAN .LE. KMINGES) THEN
               KMINGES=KMEAN
               JMIN=J
            ENDIF
         ENDIF 
 23   CONTINUE

* Deleting the station JMIN from the current network   

      S(JMIN)=0

* Determining the station with the smallest index in the current network   

      IF (JMIN.EQ.JMAX) THEN
         DO 232 J=JMIN+1,NE
            IF (S(J).NE.0) THEN
               GOTO 233
            ENDIF
 232     CONTINUE
 233     JMAX=J         
      ENDIF

      GOTO 20

* Greedy solution found

 30   CONTINUE

* Calculating krige prediction and krige variance for the greedy solution

      NI=NF+NS
      CALL PIND(S,IND,NA,NE,NF,NI)
      DO 40 L=NF+1,NI
         LLON(L)=LON(IND(L))
         LLAT(L)=LAT(IND(L))
 40   CONTINUE
      CALL PSUBM(COV,NA,NA,LCOV,NA,IND,NI)
      CALL KRIGE_GRID(XSW,YSW,XNE,YNE,ANGLE,NX,NY,
     .     DX,DY,XG,YG,ZG,VARG,DOG,
     .     LLON,LLAT,Z,EXTRAP,NI,
     .     COVTYPE,COVPAR,LCOV,LDCOV,EXTCOV,TREND,
     .     NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,MODE,MU,LAMBDA,BITS,
     .     RETLM,IERR)
            

      OPT=KMINGES
      RETURN
      END 
      
