kde.old <- function(data, kernel, h, points)
{
# kernel density estimation use C-code
# which employs selected S-function
# select function
  switch(kernel,
    fun<-uniform,
    fun<-triangle,
    fun<-epanechnikov,
    fun<-quartic,
    fun<-triweight,
    fun<-kgaussian,
    fun<-cosinus)
  data <-data[!is.na(data)]
  n<-length(data)
# Use list() to send a function to C
  result <- .C("kernelestimation",
    list(fun),
    as.double(data),
    as.integer(n),
    double(points),
    double(points),
    as.integer(kernel),
    as.double(h),
    as.integer(points), 
# comma omitted in book
    as.double(range(data)))
# final ) omitted in book 
  final.result <- matrix(c(result[[4]], result[[5]]), points, 2)
  final.result
}

uniform<-function(x)
{
  result <- .5 * (abs(x) <= 1)
  result
}
triangle<-function(x)
{
  result <- (1 - abs(u)) *(abs(x) <= 1)
  result
}
epanechnikov<-function(x)
{
  result <- .75 * (1 - x^2) * (abs(x) <= 1)
  result
}
quartic<-function(x)
{
  result <- .9375 * (1-x^2)^2 *(abs(x) <= 1)
  result
}
triweight<-function(x)
{
  result <- 1.09375 * (1-x^2)^3 *(abs(x) <= 1)
  result
}
kgaussian<-function(x)
{
  result <- 0.3989 * exp(-0.5*x*x)
  result
}
cosinus<-function(x)
{
  result <- 0.25*pi * cos(pi*0.5*x) * (abs(x) <= 1)
  result
}
