# WARPing density estimation in S
# expected parameter : data x, bandwidth h, number of
# small bins M and the chosen kernel, coded by 1 up to 5.
# 1 = Uniform, 2 = Triangle (ASH), 3 = Epanechnikov,
# 4 = Quartic, 5 = Triweight, 6 = Gaussian
#
warping <-function(x,h,M,kernel)
{
	x <-x[!is.na(x)]
	n <-length(x)
	if(kernel == 6) {h <- h*4; M <- 4*M}
	delta <-h/M
# delta is the binwidth of the small bins
	numbin<-floor((max(x)-min(x))/delta)+2*(M+1+ceiling(M/10))
	start<-min(x)-h-delta*0.1
	origin<-(floor(start/delta)-0.5)*delta
	max.notempty<-min(n+1,numbin)
	z<-.C("warp",
		as.double(x),
		result=  double(numbin),
		as.double(h),
		double(M),
		as.double(origin),
		integer(numbin),
		integer(max.notempty),
		integer(max.notempty),
		as.integer(M),
		as.integer(n),
		as.integer(kernel))$result
	warp<-matrix(0,numbin,2)
	warp[,1]<-(0.5+c(0:(numbin-1)))*delta+origin
	warp[,2]<-z
	warp
} 

