regression.data <- function(n, seed)
{
	.Random.seed <<- seed
	x <- sort(runif(n))
	m <- (sin(2 * pi * x^3))^3
	e <- rnorm(n) * sqrt(.1)
	y <- m + e
	result <- list(x = x, y = y, m = m, e = e)
	result
}
seed<-c( 13, 22, 28, 13 ,47,  0 ,45, 38, 15, 37, 28 , 2)
dat.reg <- regression.data(256, seed)
rm(regression.data,seed)
