/* Algorithm for calculation of the WARPing-approximation	*/
/* of NADARAYA-WATSON -regression estimate			*/
/* 1-dimensional predictor with 5 different kernels		*/
#include<stdio.h>
#include<math.h>

warpingregression(x,y,h,M,fM,rM,mM,kwe,origin,bin,frequ,ysum,
			index,n,numbin,kernel,fM0)

/* x <==> 1 - dim predictor					*/
/* y <==> 1 - dim response					*/
/* h <==> smoothing parameter					*/
/* M <==> number of small bin in one large window		*/
/* fM <==> density estimation of predictor density		*/
/* rM <==> estimation of numerator				*/
/* mM <==> conditional expectation of y given x			*/
/* kwe <==> weights depending on the different kernels		*/
/* origin <==> left boundary of first bin			*/
/* bin <==> flag for non-empty bins				*/
/* frequ <==> counts  in non-empty bins				*/
/* ysum <==> sum of response-observations in non-empty bins	*/
/* index <==> index of non-empty bins 				*/
/* n <==> number of observations				*/
/* numbin <==> total number of small bins			*/
/* kernel <==> type of kernel coded 1 to 5			*/
/* fM0 <==> flag for na-handling				*/

double*x,*y,*fM,*rM,*mM,*h,*kwe,*origin,*ysum;
long*M,*n,*kernel,*bin,*frequ,*index,*numbin,*fM0;
{
  register long i,j,k;
  double delta;
  long iabs,indexi,nl;
  delta=h[0]/(double)M[0];
  nl=0;
/* Binning the data						*/

  for (i=0;i<n[0];i++)
  {
    j=floor((x[i]-origin[0])/delta);
    if (bin[j]==0) /* first observation in bin j */
    {
      ++nl;
      frequ[nl] = 1;
      ysum[nl]=y[i];
      index[nl]=j;
      bin[j]=nl;
    }
    else
    {
      frequ[bin[j]]++;
      ysum[bin[j]]+=y[i];
    }
  }

/* Creating weights.						*/
/* Note. weights are not normalised 				*/
  switch ( *kernel )
  {
    case 1 :
/* uniform-kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=1;
      break;
    }
    case 2 :
/* Triangle - kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=1.0-(double)i/(double)M[0];
      break;
    }
    case 3 :
/* Epanechnikov - kernel 					*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=1.0-pow((double)i/(double)M[0], 2.0);
      break;
    }
    case 4 :
/* Quartic - kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=pow(1.0-pow((double)i/(double)M[0],2.0),2.0);
      break;
    }
    case 5 :
/* Triweight-kernel 						*/
    {
      for (i=0;i<M[0];i++)
        kwe[i]=pow(1.0-pow((double)i/(double)M[0],2.0),3.0);
      break;
    }
    default: 
    {  
      printf("error in the choice of kernel %d!", *kernel);
      return;
    }
  }
/* end of the switch-part					*/

/* Weighting the bins						*/
  for (k=1;k<nl+1;k++)
  {
    for (i=1-M[0];i<M[0];i++)
    {
      indexi=i+index[k];
      iabs=abs(i);
      fM[indexi]+=kwe[iabs]*(double)frequ[k];
      rM[indexi]+=kwe[iabs]*ysum[k];
    }
  }
  
/* combination of numerator and denominator			*/
  if((*fM0)==1)
  {
/* Estimate is set to 0, if fM[j]=0 				*/
    for(j=0;j<(*numbin);j++)
    {
      if(fM[j]==0)
        mM[j]=0;
      else
        mM[j]=rM[j]/fM[j];
    }
  }
  else
  {
/* generation of missings possible, if fM[j]=0 			*/
    for(j=0;j<(*numbin);j++)
      mM[j]=rM[j]/fM[j];
  }
} /* end */
   
      				        
