\name{fit.variogram}
\title{Variogram Model Fit}
\usage{fit.variogram(model="exponential", ...)
fit.exponential(variogram.obj, c0, ce, ae, type='c', 
                iterations=10, tolerance=1e-06, plot.it=F, weighted=T)
fit.gaussian(variogram.obj, c0, cg, ag, type='c', 
             iterations=10, tolerance=1e-06, plot.it=F, weighted=T)
fit.spherical(variogram.obj, c0, cs, as, type='c', delta=0.1, 
              iterations=10, tolerance=1e-06, plot.it=F, weighted=T)
fit.wave(variogram.obj, c0, cw, aw, type='c', 
         iterations=10, tolerance=1e-06, plot.it=F, weighted=T)
fit.linear(variogram.obj, plot.it=F)}
\alias{fit.exponential}
\alias{fit.wave}
\alias{fit.gaussian}
\alias{fit.spherical}
\alias{fit.linear}
\arguments{
\item{model}{only available for \code{fit.variogram}, switches what kind
  of model should be fitted (\code{"exponential", "wave", "gaussian",
  "spherical", "linear"}).}
\item{variogram.obj}{a variogram object generated by \code{est.variogram()}}
\item{c0, ce, ae}{initial estimates for the exponential variogram model}
\item{c0, cg, ag}{initial estimates for the gaussian variogram model}
\item{c0, cs, as}{initial estimates for the sperical variogram model}
\item{c0, cw, aw}{initial estimates for the periodical variogram model}
\item{type}{one of \code{'c'} (classic), \code{'r'} (robust), \code{'m'} (median). Indicates to which type of empirical variogram estimate the model is
to be fit.}
\item{iterations}{the number of iterations of the fitting procedure to execute.}
\item{tolerance}{the tolerance used to determine if model convergence has been achieved.}
\item{delta}{initial stepsize (relative) for pseudo Newton approximation, applies only to \code{fit.spherical}}
\item{plot.it}{if T, the variogram estimate will be plotted each iteration.}
\item{weighted}{if T, the fit will be done using weighted least squares, where the weightes are given in Cressie (1991, p. 99)}
}
\value{A variogram.model object:
\item{parameters}{vector of fitted model parameters}
\item{model}{function implementing a valid variogram model}
}
\description{Fit variogram models (exponential, spherical, gaussian, linear) to empirical variogram estimates. 

  
  
An object of class variogram.model represents a fitted variogram model generated by fitting a function to a variogram object. A
variogram.model object is composed of a list consisting of a vector of parameters, \code{parameters}, and a semi-variogram model
function, \code{model}.
}
\note{\code{fit.exponential}, \code{fit.gaussian} and \code{fit.wave}
  use an iterative, Gauss-Newton fitting algorithm to fit to an
  exponential or gaussian variogram model to empirical variogram estimates.
\code{fit.spherical} uses the same algorithm but with differential
  quotients in place of first derivatives. When \code{weighted} is
  \code{T}, the regression is weighted by \eqn{n(h)/gamma(h)^2} where
  the numerator is the number of pairs of points in a given lag. }
\seealso{\code{\link{est.variogram}}}
\examples{
maas.vmod<-fit.gaussian(maas.v,c0=60000,cg=110000,ag=800,plot.it=T)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
