/* ../src/inhull.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int inhull_(xp, yp, np, x, y, n, list, lptr, lend, inh)
doublereal *xp, *yp;
integer *np;
doublereal *x, *y;
integer *n, *list, *lptr, *lend;
logical *inh;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    extern logical left_();
    static integer k, n0, n1, nk, ip, lp, nst, nkm1;


/* *********************************************************** */

/*                                               From TRIPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                             (817) 565-2767 */
/*                                                   09/01/88 */

/*   Modified version of BNODES from TRIPACK */
/*   Albrecht Gebhardt <albrecht.gebhardt@uni-klu.ac.at> */

/* This function returns TRUE if a given point is contained */
/* in the convex hull of a given triangulation. */

/* On input: */

/*       PX,PY = coordinates of the point to be located */

/*       X,Y = Arrays containing the coordinates of the nodes */
/*             in the triangulation. */

/*       N = Number of nodes in the triangulation.  N .GE. 3. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to subroutine */
/*                        TRMESH. */

/* The above parameters are not altered by this routine. */

/* Return value: */

/*       TRUE if (PX,PY) lies in convex hull of the triangulation. */

/*       This is determined by sequentially applying the LEFT */
/*       function along the boundary (counterclockwise). */
/*       If all these tests return TRUE (PX,PY) lies in the convex hull. 
*/

/* Modules required by INHULL:  LEFT */

/* *********************************************************** */

    /* Parameter adjustments */
    --xp;
    --yp;
    --x;
    --y;
    --lend;
    --list;
    --lptr;
    --inh;

    /* Function Body */
    i__1 = *np;
    for (ip = 1; ip <= i__1; ++ip) {

/*     initialize LOGICAL INH */

	inh[ip] = TRUE_;

/*     Set NST to the first boundary node encountered. */

	nst = 1;
L1:
	lp = lend[nst];
	if (list[lp] < 0) {
	    goto L2;
	}
	++nst;
	goto L1;

/*     Initialization. */

L2:
	n1 = nst;
	nk = nst;
	k = 1;
	n0 = nst;

/*     Traverse the boundary in counterclockwise order. */

L3:
	lp = lend[n0];
	lp = lptr[lp];
	n0 = list[lp];
	if (n0 == nst) {
	    goto L4;
	}
	++k;
	nkm1 = nk;
	nk = n0;

/*    Check if point (X,Y) is left of the line through NODES(K-1)->NOD
ES(K),*/

	inh[ip] = inh[ip] && left_(&x[nkm1], &y[nkm1], &x[nk], &y[nk], &xp[ip]
		, &yp[ip]);
	goto L3;

/*    Check if point (X,Y) is left of the line through NODES(NB)->NODE
S(1),*/

L4:
	inh[ip] = inh[ip] && left_(&x[nk], &y[nk], &x[n1], &y[n1], &xp[ip], &
		yp[ip]);
/* L10: */
    }
    return 0;
} /* inhull_ */

/* Subroutine */ int onhull_(xp, yp, np, x, y, n, list, lptr, lend, onh)
doublereal *xp, *yp;
integer *np;
doublereal *x, *y;
integer *n, *list, *lptr, *lend;
logical *onh;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    extern logical left_();
    static integer k, n0, n1, nk, ip, lp;
    extern logical border_();
    static integer nst, nkm1;


/* *********************************************************** */

/*                                               From TRIPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                             (817) 565-2767 */
/*                                                   09/01/88 */

/*   Modified version of BNODES from TRIPACK */
/*   Albrecht Gebhardt <albrecht.gebhardt@uni-klu.ac.at> */

/* This function returns TRUE if a given point lays */
/* on the convex hull of a given triangulation. */

/* On input: */

/*       PX,PY = coordinates of the point to be located */

/*       X,Y = Arrays containing the coordinates of the nodes */
/*             in the triangulation. */

/*       N = Number of nodes in the triangulation.  N .GE. 3. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to subroutine */
/*                        TRMESH. */

/* The above parameters are not altered by this routine. */

/* Return value: */

/*       TRUE if (PX,PY) lies on the convex hull of the triangulation. */

/*       This is determined by sequentially applying the LEFT */
/*       function along the boundary (counterclockwise, to ensure */
/*       (PX,PY) is IN the hull) and applying BORDER to check if it */
/*       lays ON some border segment */

/* Modules required by ONHULL:  LEFT, BORDER */

/* *********************************************************** */

    /* Parameter adjustments */
    --xp;
    --yp;
    --x;
    --y;
    --lend;
    --list;
    --lptr;
    --onh;

    /* Function Body */
    i__1 = *np;
    for (ip = 1; ip <= i__1; ++ip) {

/*     initialize LOGICAL INH */

	onh[ip] = TRUE_;

/*     Set NST to the first boundary node encountered. */

	nst = 1;
L1:
	lp = lend[nst];
	if (list[lp] < 0) {
	    goto L2;
	}
	++nst;
	goto L1;

/*     Initialization. */

L2:
	n1 = nst;
	nk = nst;
	k = 1;
	n0 = nst;

/*     Traverse the boundary in counterclockwise order. */

L3:
	lp = lend[n0];
	lp = lptr[lp];
	n0 = list[lp];
	if (n0 == nst) {
	    goto L4;
	}
	++k;
	nkm1 = nk;
	nk = n0;

/*    Check if point (X,Y) is left of the line through NODES(K-1)->NOD
ES(K),*/

	onh[ip] = onh[ip] && left_(&x[nkm1], &y[nkm1], &x[nk], &y[nk], &xp[ip]
		, &yp[ip]);
	goto L3;

/*    Check if point (X,Y) is left of the line through NODES(NB)->NODE
S(1),*/

L4:
	onh[ip] = onh[ip] && left_(&x[nk], &y[nk], &x[n1], &y[n1], &xp[ip], &
		yp[ip]);
	if (onh[ip]) {
/*     IP is IN the hull, now check if it is ON the hull: */
	    onh[ip] = FALSE_;
	    nst = 1;
L11:
	    lp = lend[nst];
	    if (list[lp] < 0) {
		goto L12;
	    }
	    ++nst;
	    goto L11;

/*     Initialization. */

L12:
	    n1 = nst;
	    nk = nst;
	    k = 1;
	    n0 = nst;

/*     Traverse the boundary in counterclockwise order. */

L13:
	    lp = lend[n0];
	    lp = lptr[lp];
	    n0 = list[lp];
	    if (n0 == nst) {
		goto L14;
	    }
	    ++k;
	    nkm1 = nk;
	    nk = n0;

/*     Check if point (X,Y) is on the line through NODES(K-1)->NOD
ES(K), */

	    onh[ip] = onh[ip] || border_(&x[nkm1], &y[nkm1], &x[nk], &y[nk], &
		    xp[ip], &yp[ip]);
	    goto L13;

/*     Check if point (X,Y) is on the line through NODES(NB)->NODE
S(1), */

L14:
	    onh[ip] = onh[ip] || border_(&x[nk], &y[nk], &x[n1], &y[n1], &xp[
		    ip], &yp[ip]);
	}
/* L10: */
    }
    return 0;
} /* onhull_ */

logical border_(x1, y1, x2, y2, x0, y0)
doublereal *x1, *y1, *x2, *y2, *x0, *y0;
{
    /* System generated locals */
    logical ret_val;

    /* Local variables */
    static doublereal dx1, dy1, dx2, dy2;


/* *********************************************************** */

/*                                               From TRIPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                             (817) 565-2767 */
/*                                                   09/01/88 */

/* modified version of LEFT: A. Gebhardt */

/*   This function determines whether node N0 is on the line */
/* through N1-N2 */



/* On input: */

/*       X1,Y1 = Coordinates of N1. */

/*       X2,Y2 = Coordinates of N2. */

/*       X0,Y0 = Coordinates of N0. */

/* Input parameters are not altered by this function. */

/* On output: */

/*       BORDER = .TRUE. if and only if (X0,Y0) is on the */
/*              directed line N1->N2. */

/* Modules required by BORDER:  None */

/* *********************************************************** */


/* Local parameters: */

/* DX1,DY1 = X,Y components of the vector N1->N2 */
/* DX2,DY2 = X,Y components of the vector N1->N0 */

    dx1 = *x2 - *x1;
    dy1 = *y2 - *y1;
    dx2 = *x0 - *x1;
    dy2 = *y0 - *y1;


    ret_val = dx1 * dy2 == dx2 * dy1;
    return ret_val;
} /* border_ */

