#include <pvm3.h>
#include "pvmstuff.h"
#include "inet.h"
#include <math.h>
#include <stdio.h>
#include "model.h"
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include "pvm_error.h"
#include "pvm_debug.h"

//#define FULL_DEBUG 1 
#ifdef FULL_DEBUG
#define PVM_DEBUG 1 
#endif
// todo: replace all TEST_NULL functions
//       replace debug functions
#ifdef PVM_DEBUG
 FILE *fp;
#endif

#define TEST_NULL(memory,msg)  \
 if (memory==NULL) { \
   syslog(LOG_WARNING,msg); \
   closelog(); \
   status=pvm_exit(); \
   pvm_error(PVM_EXIT,status,"<pvm_exit> failed!\n"); \
   exit(EXIT_FAILURE); \
 }

double (*f)(double);
// different models require different functions
double (*model_function)(double,double,double,double);

double gaussian(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else return (p1 + p2 * (1 - exp(-pow(h,2.0)/pow(p3,2.0))));
}

double linear(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else return (p1+p2*h);  
}

double exponential(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else return (p1+p2*(1-exp(-h/p3)));
}

double spherical(double h, double p1, double p2, double p3) {
  if (h==0.0) return 0.0;
  else if (h<=p3) return (p1+p2*(3.0/2.0 * h/p3 - 0.5*pow(h/p3,3.0)));
  else return (p1+p2);
}

/* distance

   calculate the distance between every data point and the point we want to estimate
*/
static void distance(double *pointx,double *pointy,double *pointz,long len,double x,double y,double *dst) {
#ifdef FULL_DEBUG
  fp=fopen("/tmp/pvm_client_distance.txt","a");  
#endif
  while ((len--)>0){ 
#ifdef FULL_DEBUG
    fprintf(fp,"i(%d), pointx[i]=(%f),pointy[i]=(%f),x(%f),y(%f)",len,pointx[len],pointy[len],x,y);
#endif        
    dst[len]=pow(pow(pointx[len]-x,2.0)+pow(pointy[len]-y,2.0),0.5);
#ifdef FULL_DEBUG
    fprintf(fp,",dst(%f)\n",dst[len]);
#endif
  }
#ifdef FULL_DEBUG
  fclose(fp);
#endif
}

/* strmv

   do the matrix-vector multiplication to create lambda.hat (w) - vector
 */
static void strmv(double *gmatrix_inv,long len,double *gvector,double *lambda_hat) {
  double tmp,val;
  int line,col;


#ifdef FULL_DEBUG
  fp=fopen("/tmp/pvm_client_strmv.txt","a");
  fprintf(fp,"strmv\n");
#endif

  for (line=0; line<len; line++) {
    tmp=0.0;
    for (col=0; col<len; col++) { 
      val=*(gmatrix_inv+line+col*len);
#ifdef FULL_DEBUG
      if (line<3) {
	fprintf(fp,"Gmatrix.inv[%d,%d]=%g\n",line,col,val);
	fprintf(fp,"gvector[%d]=%g\n",col,gvector[col]);
	fprintf(fp,"tmp=%e\n",tmp);
      }
#endif
      tmp=tmp+val*(gvector[col]);
    }
    lambda_hat[line]=tmp;
#ifdef FULL_DEBUG
    fprintf(fp,"%e\n",tmp);
#endif    
  }
#ifdef FULL_DEBUG
    fclose(fp);
#endif
}
/* gammaOh

   create gvector (right hand side of equation)
*/

static void gammaOh(double *dst,long len,double param0,double param1,double param2,double *gvector) {
  while (len-->0) 
    gvector[len]=model_function(abs(dst[len]),param0,param1,param2);
}

static double summe(double *a,double *b,long len) {
  double tmp=0.0;

  while (len-->0) 
    tmp+=a[len]*b[len];
  return tmp;
}

int main(void) {
  int     ptid, cc, i;
 
  double *zhat, *sigma2hat; 
  double *gvector;
  double *dst;
  double *lambda_hat;
  double *pointx, *pointy, *pointz;
  double *gmatrix_inv;
  message parameter;
  result res;
  job todo;
  int status;
  pid_t client_pid;
#ifdef PVM_DEBUG
  int tmp,line,col;
#endif
  
  openlog("pvm_client",LOG_PID|LOG_ODELAY,LOG_DAEMON);  

  __SET_DEBUG_FILE("/tmp/pvm_client.txt");
  
  client_pid=getpid();
  __DEBUG2("Starting pvm_client with PID %i!\n", client_pid);
  //  sleep(60);
  // get master tid
  ptid = pvm_parent(); 
  pvm_error(PVM_PARENT,ptid,"<pvm_parent> failed!\n");
  // initial part
  // receive parameter settings
  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkint((int*)&(parameter.int_message),sizeof(message_int)/sizeof(int),1); 
  pvm_error(PVM_UPKINT,status,"<pvm_upkint> failed!\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)&(parameter.double_message),sizeof(message_double)/sizeof(double),1); 
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

 
  __DEBUG2("Parameter: plen (%i) \n",parameter.int_message.plen);
  __DEBUG2("Parameter: slen (%i) \n",parameter.int_message.slen);
  __DEBUG2("Parameter: model (%d) \n",parameter.int_message.model);
  __DEBUG2("Parameter: param0 (%f) \n",parameter.double_message.param0);
  __DEBUG2("Parameter: param1 (%f) \n",parameter.double_message.param1);
  __DEBUG2("Parameter: param2 (%f) \n",parameter.double_message.param2);

  __DEBUG1("Memory allocated!\n");

  // set function point to required function
  switch (parameter.int_message.model) {
  case GAUSSIAN_MODEL: 
    model_function=gaussian;
    break;
  case EXPONENTIAL_MODEL:
    model_function=exponential;
    break;
  case LINEAR_MODEL:
    model_function=linear;
    break;
  case SPHERICAL_MODEL:
    model_function=spherical;
    break;
  default: 
    syslog(LOG_WARNING,"Wrong model specified (%d)",parameter.int_message.model);
    closelog();
    status=pvm_exit();
    pvm_error(PVM_EXIT,status,"<pvm_exit> failed!\n");
    exit(EXIT_FAILURE);
  }

  // allocate variables
  gvector=(double*)malloc((parameter.int_message.plen+1)*sizeof(double));  
  TEST_NULL(gvector,"Memory allocation problem (gvector)");

  dst=(double*)malloc(parameter.int_message.plen*sizeof(double));
  TEST_NULL(dst,"Memory allocation problem (dst)");

  lambda_hat=(double*)malloc((parameter.int_message.plen+1)*sizeof(double));
  TEST_NULL(lambda_hat,"Memory allocation problem (lambda_hat)");

  pointx=(double*)malloc(sizeof(double)*(parameter.int_message.plen));
  TEST_NULL(pointx,"Memory allocation problem (pointx)");

  pointy=(double*)malloc(parameter.int_message.plen*sizeof(double));
  TEST_NULL(pointy,"Memory allocation problem (pointy)");

  pointz=(double*)malloc(parameter.int_message.plen*sizeof(double));
  TEST_NULL(pointz,"Memory allocation problem (pointz)");
 
  gmatrix_inv=(double*)malloc((parameter.int_message.plen+1)*(parameter.int_message.plen+1)*sizeof(double));
  TEST_NULL(gmatrix_inv,"Memory allocation problem (gmatrix_inv)");
 
  __DEBUG1("Memory allocated!\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)pointx,parameter.int_message.plen,1);
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("Got pointx!\n");

  cc = pvm_recv(ptid, MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)pointy,parameter.int_message.plen,1);
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("Got pointy!\n");

  cc = pvm_recv(ptid,  MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)pointz,parameter.int_message.plen,1);
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("Got pointz!\n");

  cc = pvm_recv(ptid,  MSGTAG_INITIALSEND);
  pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
  status=pvm_upkdouble((double*)gmatrix_inv,(parameter.int_message.plen+1)*(parameter.int_message.plen+1),1);
  pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

  __DEBUG1("Got gmatrix_inv!\n");

#ifdef FULL_DEBUG
  fp=fopen("/tmp/pvm_client_input.txt","a");
  fprintf(fp,"\n---------point------------- \n");

  for (tmp=0; tmp<parameter.int_message.plen; tmp++) { 
    fprintf(fp,"pointx[%d]=%f\n",tmp,pointx[tmp]);
    fprintf(fp,"pointy[%d]=%f\n",tmp,pointy[tmp]);
    fprintf(fp,"pointz[%d]=%f\n",tmp,pointz[tmp]);
  }
 
  fprintf(fp,"\n---------gmatrix_inv-------------- \n");
  
  for (line=0; line<(parameter.int_message.plen+1); line++) {     
    for (col=0; col<(parameter.int_message.plen+1); col++) 
      fprintf(fp,"%e\t",*(gmatrix_inv+line+col*(parameter.int_message.plen+1)));
    fprintf(fp,"\n");
  }
 
  fclose(fp);
#endif

  // got initial data - wait for jobs
  while (1) {
    cc = pvm_recv(ptid,MSGTAG_SENDJOB);
    pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
    status=pvm_upkdouble((double*)&todo,sizeof(job)/sizeof(double),1);	    
    pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed!\n");

    __SET_DEBUG_FILE("/tmp/pvm_client_todo.txt");
    __DEBUG1("Got something todo!\n");
    __DEBUG2("Number of points to compute: %d\n",(int)todo.nr_points);
    
    res.id=todo.id; // we return the same id nr as we received
    if ((int)todo.nr_points>0) {
      res.nr_points=todo.nr_points;
      // run over the points we got  
      for(i=0; i<(int)todo.nr_points; i++) {
        __SET_DEBUG_FILE("/tmp/pvm_client_debug.txt");
	__DEBUG5("todo: sx[%d]=%f,sy[%d]=%f",i,todo.sx[i],i,todo.sy[i]);

	distance(pointx,pointy,pointz,parameter.int_message.plen,todo.sx[i],todo.sy[i],dst);

#ifdef FULL_DEBUG
	fp=fopen("/tmp/pvm_client_dst.txt","a");
	fprintf(fp,"\n--test: %d\n",i);
      
	for (tmp=0; tmp<parameter.int_message.plen; tmp++) 
	  fprintf(fp,"dst[%d]=%f\n",tmp,dst[tmp]);

	fclose(fp);
#endif  
	gammaOh(dst,parameter.int_message.plen,parameter.double_message.param0,parameter.double_message.param1,parameter.double_message.param2,gvector);
	gvector[parameter.int_message.plen]=1.0; 
#ifdef FULL_DEBUG
	fp=fopen("/tmp/pvm_client_gvector.txt","a");
	fprintf(fp,"par[1]: %f\n",parameter.double_message.param0);
	fprintf(fp,"par[2]: %f\n",parameter.double_message.param1);
	fprintf(fp,"par[3]: %f\n",parameter.double_message.param2);
	//fprintf(fp,"\n--test: %d\n",i);

	for (tmp=0; tmp<(parameter.int_message.plen+1); tmp++) 
	  fprintf(fp,"gvector[%d]=%f\n",tmp,gvector[tmp]);

	fclose(fp);
#endif
	strmv(gmatrix_inv,parameter.int_message.plen+1,gvector,lambda_hat);

	res.zhat[i]=summe(pointz,lambda_hat,parameter.int_message.plen);

	res.sigma2hat[i]=summe(lambda_hat,gvector,parameter.int_message.plen);

	__SET_DEBUG_FILE("/tmp/pvm_client_debug.txt");
	//__DEBUG2("\n--test %d\n",i);

	__DEBUG3("zhat[%d]= %f\n",i,res.zhat[i]);
	__DEBUG3("sigma2hat[%d]= %f\n",i,res.sigma2hat[i]);
      } // end for (points) 
     
      __SET_DEBUG_FILE("/tmp/pvm_client.txt");
      __DEBUG1("Send results back...\n");

      // send result
      status=pvm_initsend(PvmDataDefault);
      pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
      status=pvm_pkdouble((double*)&res,sizeof(result)/sizeof(double),1);
      pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed!\n");
      status=pvm_send(ptid, MSGTAG_KRIGE);
      pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

      __DEBUG1("Results were send...\n");
    } // end if (todo.nr_points>0)
  } // end while 

  // prg will never reach these lines - 
  // because master kills clients
  status=pvm_exit(); 
  pvm_error(PVM_EXIT,status,"<pvm_exit> failed!\n");

  return(EXIT_SUCCESS);
}

