#include "pvmstuff.h"
#include "inet.h"
#include <stdlib.h>
#include <syslog.h>
#include <stdio.h>
#include <string.h>
#include "pvm_error.h"
#include "pvm_debug.h"
#include "tmeasure.h"
#include "pvm_tiles.h"


// pvm_krige_tiles is executed by krige_server.c after all data is received from R
// the main purpose of this function is to start the pvm_clients and to do the job handling

void pvm_krige_tiles(double *lon,
		     double *lat,
		     double *z,
		     double *xgwork,
		     double *ygwork,
		     int *dog,
		     static_msg param,
		     size_msg param_size,
		     double *zg,
		     double *varg,
		     int *gridcnt)
{
    int i,j,k,worker,resolve; 
    int jobs_pending=0,cc,bytes_sent;
    int proceed,recvmsgtag,singletid;
    int *tid;
    tile_host_t tile_host;
    int points_to_send;
    double *result_buffer;
    tile_job_queue_t tile_job_queue; 

    tile_job **tile_joblist;
    tile_result **tile_resultlist;  
    tile_job *jobptr;
    tile_result *resptr;

    // message parameter;
    int status,single_tid;
    tile_host_t *hostptr;
    int nr_worker;

    // job queue variables
    int pxper;
    int pyper;
    int tcnt;
    tjqueue_t *last_entry;
    tjqueue_t *queue_entry;


#ifdef PVM_DEBUG
    int x;
#endif
    FILE *fp;

    //  init 
    tile_job_queue.first=NULL;
    tile_job_queue.nr=0;
    tile_job_queue.nr_done=0;
    tile_job_queue.nr_todo=0;
    tile_job_queue.jobs_pending=0;
    tile_job_queue.id_counter=0;
 
    openlog("krige_server",LOG_PID|LOG_ODELAY,LOG_DAEMON);  

    __DEBUG1("Entry pvm_krige...\n");


    // array of pointers to jobs sent to clients - 
    // we have to keep track of those because the tile_results are not returned
    // in their inital order
    tile_joblist=(tile_job**)malloc(sizeof(tile_job*)*param_size.nt);
    if (tile_joblist==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (tile_joblist)");
	closelog();
	exit(EXIT_FAILURE);
    }
   
    for (i=0; i<param_size.nt; i++) {
	tile_joblist[i]=NULL;
	//    tile_resultlist[i]=NULL;
    }
  
    fp=fopen(PVM_HOSTFILE,"r");
    if (fp==NULL) {
	__DEBUG1("No pvm_hosts file found - use pvm configuration\n");
      
	// file does not exit --> we use pvm to 
	// add hosts to the file
	status=add_tile_hosts2pvm(PVM_ADDS_HOSTS);
    } else {
	fclose(fp);
	__DEBUG1("Found pvm_hosts file!\n");
	// if file exits - read it and call pvm_addhosts
	status=add_tile_hosts2pvm(FILE_ADDS_HOSTS );
    }
    if (status<=0) {
	// adding some workers failed
	syslog(LOG_WARNING,"Unable to find any hosts to add!");
	exit(EXIT_FAILURE);
    }
  
    tid=(int*)malloc(sizeof(int)*tile_hostlist.nr);
    if (tid==NULL) {
	syslog(LOG_WARNING,"Memory allocation problems (tid)!");
	exit(EXIT_FAILURE);
    }
    // not done yet: need to supply a vector with hostnames instead of pvmtaskdefault
    hostptr=tile_hostlist.first_host;

    // start each client individually to make a direct connection between hostname and tid 
    for (i=0; i<tile_hostlist.nr; i++) {
	//status=pvm_spawn(CLIENT_TO_START, (char**)0, PvmTaskDefault, (char*)0, tile_hostlist.nr, tid);
	status=pvm_spawn(CLIENT_TO_START, (char**)0, PvmTaskHost,hostptr->hostname, 1, &singletid);
	pvm_error(PVM_SPAWN,status,"<pvm_spawn> failed - unable to add client!\n");  
	tid[i]=singletid;
	if (settilejobdata_init(hostptr->hostname,singletid)==-1) {
	    syslog(LOG_WARNING,"settilejobdata_init failed - could not find hostname");
	    closelog();
	    exit(EXIT_FAILURE);
	}
	// add notifications
	status=pvm_notify(PvmTaskExit,MSGTAG_TASKDIED,1,&singletid);
	pvm_error(PVM_NOTIFY,status,"<pvm_notify - PvmTaskExit> failed!\n");  
      
	status=pvm_notify(PvmHostDelete,MSGTAG_HOSTDELETE,1,&singletid);
	pvm_error(PVM_NOTIFY,status,"<pvm_notify - PvmHostDelete> failed!\n");  
      
	status=pvm_notify(PvmHostAdd,MSGTAG_HOSTADD,1,&singletid);
	pvm_error(PVM_NOTIFY,status,"<pvm_notify - PvmHostAdd> failed!\n");  
	hostptr=hostptr->next;
    } 
  
    __DEBUG2("Spawned clients # %d\n",tile_hostlist.nr);

#ifdef PVM_DEBUG
#endif

    // send configuration to client
#ifdef USE_MULTICAST 
    send_tile_init_multicast(&parameter,tid,pointx,pointy,pointz,gmatrix_inv,
			     tile_hostlist.nr,plen);
#else
    send_tile_init_unicast(lon,lat,z,xgwork,ygwork,dog,param,param_size,
			   tid,nr_worker);
#endif


    pxper=0-param_size.nxper;
    pyper=0-param_size.nyper;
    tcnt=0;
    last_entry=NULL;
    
    for (i=0; i<param_size.ntx;i++){
	pxper+=param_size.nxper;
	for (j=0; j<param_size.nty;j++){
	    pyper+=param_size.nyper;
	    tcnt+=1;
	    jobptr=create_job(i*param_size.itx-pxper,
			      (i+1)*param_size.itx-pxper-1,
			      j*param_size.ity-pyper,
			      (j+1)*param_size.ity-pyper-1,
			      param_size);
	    queue_entry=(tjqueue_t *)malloc(sizeof(tjqueue_t));
	    queue_entry->next=last_entry;
	    queue_entry->jobptr=jobptr;
	    queue_entry->todo=1;
	    last_entry=queue_entry;
	}
	pyper=0-param_size.nyper;
	
    }
    
    tile_job_queue.first=last_entry;
    tile_job_queue.nr=tcnt;
    tile_job_queue.nr_todo=tcnt;
    tile_job_queue.nr_done=0;


	// initial data points are always send unicast
    // iterate over all workers:
    
    queue_entry=tile_job_queue.first;

    for (worker=0; worker<tile_hostlist.nr; worker++) {	
	__DEBUG1("Send initial data points\n");
	
	// send job
	send_job(queue_entry, &tile_job_queue, tid[worker]);
	

	// write history data
#ifdef USE_RDTSC
	settilejobdata_start(tid[worker],(double)queue_entry->jobptr->nr_points,rdtsc(),queue_entry->jobptr);
#else
	settilejobdata_start(tid[worker],(double)queue_entry->jobptr->nr_points,time(NULL),queue_entry->jobptr);
#endif

#ifdef PVM_DEBUG
	fp=fopen("/tmp/pvm_jobs.txt",WRITE_MODE);
	fprintf(fp,"JOBNR: %d\n",queue_entry->jobptr->id);
	fprintf(fp,"i lower: %d\n",queue_entry->jobptr->i_lower);
	fprintf(fp,"i upper: %d\n",queue_entry->jobptr->i_upper);
	fprintf(fp,"i lower: %d\n",queue_entry->jobptr->j_lower);
	fprintf(fp,"i upper: %d\n",queue_entry->jobptr->j_upper);
	fprintf(fp,"nr of points: %d\n",queue_entry->jobptr->nr_points);
	fclose(fp);
#endif 

	queue_entry=queue_entry->next;
	if(queue_entry==NULL) break;

    } // end initial part
  


    // Receive - Send 
    __DEBUG1("\nInitial part finished! - enter receive - send.\n");
  
    while (tile_job_queue.nr_done<tile_job_queue.nr) {
	// allocate memory for tile_results
	resptr=(tile_result*)malloc(sizeof(tile_result));
   
	if (resptr==NULL) {
	    syslog(LOG_WARNING,"Memory allocation problem (resptr)");
	    closelog();
	    pvm_exit();
	    exit(EXIT_FAILURE);
	}
	resptr->z=(double *)malloc(sizeof(double)*(param_size.itx*param_size.ity));
	if (resptr->z==NULL) {
	    syslog(LOG_WARNING,"Memory allocation problem (resptr)");
	    closelog();
	    pvm_exit();
	    exit(EXIT_FAILURE);
	}
	resptr->var=(double *)malloc(sizeof(double)*(param_size.itx*param_size.ity));
 	if (resptr->var==NULL) {
	    syslog(LOG_WARNING,"Memory allocation problem (resptr)");
	    closelog();
	    pvm_exit();
	    exit(EXIT_FAILURE);
	}
	
	do { 
	    // we only leave this loop if we got some tile_results
	    // all other messages are handled immediately
	    // receive any message tag from any process
	    cc = pvm_recv(-1,-1); 
	    result_buffer=(double*)malloc((2*(param_size.itx*param_size.ity)+2)*sizeof(double));

	    pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
	    status=pvm_upkdouble((double*)result_buffer,(2*(param_size.itx*param_size.ity)+2),1);
	    pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed for resptr!\n");
	    status=pvm_bufinfo(cc, &bytes_sent, &recvmsgtag, &resolve);
	    pvm_error(PVM_BUFINFO,status,"<pvm_bufinfo> failed!\n");
	  
	    // evaluate message tag
	    // todo - need to determine what to do 
	    // at each message tag.
	    switch(recvmsgtag){
	    case MSGTAG_KRIGE:
		proceed=0;
#ifdef USE_RDTSC
		settilejobdata_finish(resolve,rdtsc());
#else
		settilejobdata_finish(resolve,time(NULL));
#endif
		break;
	    case MSGTAG_TASKDIED:	
		// find host
		hostptr=find_hostlistentry_by_tid(&tile_hostlist,resolve);
		if (hostptr==NULL) { // tid not found
		    syslog(LOG_WARNING,"HOSTDELETE: tid(%d) not found!",resolve);
		    closelog();
		    pvm_exit();
		    exit(EXIT_FAILURE);
		}
		// get lastjob - if there was one
		if  (hostptr->last_queueentry!=NULL) {
		    hostptr->last_queueentry->todo=1;
		    hostptr->last_queueentry=NULL; 
		    hostptr->status=HOST_STATUS_TASKDIED;
		}
		tile_job_queue.jobs_pending--;
		break;
	    case MSGTAG_HOSTDELETE:
		// find host
		hostptr=find_hostlistentry_by_tid(&tile_hostlist,resolve);
		if (hostptr==NULL) { // tid not found
		    syslog(LOG_WARNING,"HOSTDELETE: tid(%d) not found!",resolve);
		    closelog();
		    pvm_exit();
		    exit(EXIT_FAILURE);
		}
		// get lastjob - if there was one
		if  (hostptr->last_queueentry!=NULL) {
		    hostptr->last_queueentry->todo=1;
		    hostptr->last_queueentry=NULL; 
		    hostptr->status=HOST_STATUS_TASKDIED;
		}
		tile_job_queue.jobs_pending--;
		// remove host from tile_hostlist
		remove_hostlistentry(&tile_hostlist,resolve);
		break;
	    case  MSGTAG_HOSTADD:
		// add host to tile_hostlist and
		// send him the initial information

		break;
	    default:
		syslog(LOG_WARNING,"Unknown message tag received");
		closelog();
		pvm_exit();
		exit(EXIT_FAILURE);
	    }
	} while (proceed==-1);
	(tile_job_queue.jobs_pending)--;
	(tile_job_queue.nr_done)++;
	proceed=-1;
	resptr->nr_points=(int)result_buffer[0];
	resptr->id=(int)result_buffer[1];
	for(i=0;i<(int)resptr->nr_points;i++){
	    resptr->z[i]=result_buffer[2+i];
	    resptr->var[i]=result_buffer[2+(int)resptr->nr_points+i];
      }	
	
	__DEBUG3("Got tile_result (%d - bytes)- id: %d.\n",bytes_sent,resptr->id);
      

#ifdef PVM_DEBUG
	fp=fopen("/tmp/pvmstuff_results.txt",WRITE_MODE);
	fprintf(fp,"Result: id %d,nr of points: %d.\n",(int)resptr->id,(int)resptr->nr_points);
	for (x=0; x<resptr->nr_points; x++) {
	    fprintf(fp,"z[%d]=%f  var[%d]=%f\n",x,resptr->z[x],x,resptr->var[x]);
	}
	fclose(fp);
#endif

	// add tile_result to the list
	// the id of the tile_result is the same as the id of the given job
	//if (resptr->id>=0 && resptr->id<id_counter) 
	queue_entry=find_queueentry_by_id(&tile_job_queue, (int)resptr->id);
	queue_entry->resultptr = resptr;
	queue_entry->todo=0;



	if (tile_job_queue.nr_todo>0) {
	    
	    __DEBUG1("Use next free job!\n");
	    
	    if (! (queue_entry=find_next_queueentry_todo(&tile_job_queue))) {
		syslog(LOG_WARNING,"No job found!)");
		closelog();
		pvm_exit();
		exit(EXIT_FAILURE);	
	    }
	    __DEBUG1("Send job!\n");
      
	    // send job
	    
	    send_job(queue_entry, &tile_job_queue, resolve);
	    
	    // write history data
#ifdef USE_RDTSC
	    if (settilejobdata_start(resolve,(double)j,rdtsc(),queue_entry->jobptr)==-1) 
#else
	    if (settilejobdata_start(resolve,(double)j,time(NULL),queue_entry->jobptr)==-1) 
#endif
		{
		    syslog(LOG_WARNING,"settilejobdata_init failed - could not find hostname");
		    closelog();
		    exit(EXIT_FAILURE);
		}
	}
    } // end while - no more points to send
      
    __DEBUG1("\n-----------------------------------------------\n");
    __DEBUG1("all tiles done\n");
    __DEBUG1("\n-----------------------------------------------\n");

    __DEBUG2("\nStatistics: number of jobs: %d",tile_job_queue.id_counter);
      
      
    // kill pvm_clients 
    for (worker=0; worker<tile_hostlist.nr; worker++) {
	status=pvm_kill(tid[worker]);  
	pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
    }
      
#ifdef LOG_STATISTIC
    //    logjobdata();
#endif
    __DEBUG1("\nBuild result matrices.\n");
      
    for (i=0; i<param_size.nx; i++)
      for (j=0; j<param_size.ny; j++){
	  gridcnt[j*(param_size.nx)+i]=0;
	  zg[j*(param_size.ny)+i]=0;
	  varg[j*(param_size.ny)+i]=0;
      }

  
    queue_entry=tile_job_queue.first;
    while(queue_entry!=NULL){
	for(i=0;i<param_size.itx;i++){
	   for(j=0;j<param_size.ity;j++){ 
	       // fprintf(stdout,"i=%i, j=%i, qe=%x\n",i,j,queue_entry);
	       // fflush(stdout);
	       if(queue_entry->jobptr->j_lower+j<param_size.ny && 
                  queue_entry->jobptr->i_lower+i<param_size.nx){
		   zg[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                      queue_entry->jobptr->i_lower+i] = 
                        (zg[(queue_entry->jobptr->j_lower+j)*param_size.nx
                            +queue_entry->jobptr->i_lower+i] * 
                         gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                                 queue_entry->jobptr->i_lower+i] + 
                         queue_entry->resultptr->z[i*param_size.ity+j]) / 
                        (gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                         queue_entry->jobptr->i_lower+i] + 1);
		
		   varg[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                      queue_entry->jobptr->i_lower+i] = 
                        (varg[(queue_entry->jobptr->j_lower+j)*param_size.nx
                            +queue_entry->jobptr->i_lower+i] * 
                         gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                                 queue_entry->jobptr->i_lower+i] * gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                                 queue_entry->jobptr->i_lower+i] + 
                         queue_entry->resultptr->var[i*param_size.ity+j]) / 
                        ((gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                         queue_entry->jobptr->i_lower+i] + 1)*(gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+
                         queue_entry->jobptr->i_lower+i] + 1));

		   // counter erhoehen
		   gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+queue_entry->jobptr->i_lower+i] 
		  =gridcnt[(queue_entry->jobptr->j_lower+j)*param_size.nx+queue_entry->jobptr->i_lower+i]+1;
	       }
	   }
	}
	queue_entry=queue_entry->next;
    }
#ifdef PVM_DEBUG
    fp=fopen("/tmp/pvmstuff.txt",WRITE_MODE);
#endif
      
      
#ifdef PVM_DEBUG
    fprintf(fp,"pvm_tile finished !\n");
    fclose(fp);
#endif           
    
      
    closelog();
}
    


tile_job* create_job(int i_lower, int i_upper, int j_lower, int j_upper,
		     size_msg param_size){
    
    tile_job *jobptr;
    
    jobptr=(tile_job*)malloc(sizeof(tile_job));
    if (jobptr==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (jobptr)");
	closelog();
	pvm_exit();
	exit(EXIT_FAILURE);
    }
    
    jobptr->i_upper=i_upper;
    if(jobptr->i_upper<0) jobptr->i_upper=0;
    if(jobptr->i_upper>param_size.nx) jobptr->i_upper=param_size.nx;
    jobptr->i_lower=i_lower;
    if(jobptr->i_lower<0) jobptr->i_lower=0;
    jobptr->j_upper=j_upper;
    if(jobptr->j_upper<0) jobptr->j_upper=0;
    jobptr->j_lower=j_lower;
    if(jobptr->j_lower<0) jobptr->j_lower=0;
    if(jobptr->j_upper>param_size.ny) jobptr->j_upper=param_size.ny;

    jobptr->nr_points=(i_upper-i_lower+1)*(j_upper-j_lower+1);

    
    return(jobptr);
}

void send_job(tjqueue_t *queue_entry, tile_job_queue_t *t_j_q, int tid){
    int status;
    tile_host_t *hostptr;
    // send job
    if(queue_entry->todo==1){
	pvm_initsend(PvmDataDefault);
	pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");		
	queue_entry->jobptr->id=t_j_q->id_counter;
	t_j_q->id_counter++;
	    
	pvm_pkint((int*)queue_entry->jobptr,sizeof(tile_job)/sizeof(int),1);
	pvm_error(PVM_PKINT,status,"<pvm_pkint> failed for jobptr!\n");
	
	status=pvm_send(tid,MSGTAG_SENDJOB);
	if(status<0){
	    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
	}
	else{
	    queue_entry->todo=-1;
	    t_j_q->nr_todo--;
	    (t_j_q->jobs_pending)++;
	    hostptr=find_hostlistentry_by_tid(&tile_hostlist,tid);
	    hostptr->last_queueentry=queue_entry;
	}
	
    }
}


    
tjqueue_t* find_queueentry_by_id(tile_job_queue_t *t_j_q, int id){

    tjqueue_t *queue_entry;

    queue_entry=t_j_q->first;

    while(queue_entry!=NULL){
	if(id==queue_entry->jobptr->id)
	    return queue_entry;
	else
	    queue_entry=queue_entry->next;
    } 
    
    return NULL;
    
}

tjqueue_t* find_next_queueentry_todo(tile_job_queue_t *t_j_q){

    tjqueue_t *queue_entry;
    
    queue_entry=t_j_q->first;

    while(queue_entry!=NULL){
	if(queue_entry->todo==1)
	    return queue_entry;
	else
	    queue_entry=queue_entry->next;
    } 
    
    return NULL;
    
}

tile_host_t* find_hostlistentry_by_tid(tile_hostlist_t *t_h_l, int tid){

     tile_host_t *hostptr;

    hostptr=t_h_l->first_host;

    while(hostptr!=NULL){
	if(tid==hostptr->tid)
	    return hostptr;
	else
	    hostptr=hostptr->next;
    } 
    
    return NULL;
    
}

int remove_hostlistentry(tile_hostlist_t *t_h_l, int tid){

    tile_host_t *hostptr, *lasthost;
    
    hostptr=t_h_l->first_host;

    while(hostptr!=NULL){
	if(tid==hostptr->tid){
	    lasthost->next=hostptr->next;
	    // free(hostptr);
	}
	else{
	    lasthost=hostptr;
	    hostptr=hostptr->next;
	}
    } 
    
    return 0;
    
}
