#include "pvmstuff.h"
#include "inet.h"
#include <stdlib.h>
#include <syslog.h>
#include <stdio.h>
#include <string.h>
#include "pvm_error.h"
#include "pvm_debug.h"
#include "tmeasure.h"

FILE *fp;

int strlen2(char* txt) {
  int res=0;
  
  while (txt[res]!='\0') res++;
  
  return res;
}
      

// add_hosts2pvm returns the number of hosts to add
int add_hosts2pvm(int how) {
  struct pvmhostinfo *hostp;
  int i, nhost,narch,status,len;
  tile_host_t *ptr,*last;
  
  char buffer[100];

  __SET_DEBUG_FILE("/tmp/pvmstuff.txt");
  __DEBUG1("add_hosts2pvm\n");

  switch (how) {
  case FILE_ADDS_HOSTS:
    // read file and get hostnames
    fp=fopen(PVM_HOSTFILE,"r");
    if (fp==NULL) {
      return -1;
    }
    tile_hostlist.nr=0;
    ptr=tile_hostlist.first_host;
    last=NULL;

    // read every line
    while (!feof(fp)) {
      fscanf(fp,"%s\n",buffer);
      ptr=(tile_host_t *)malloc(sizeof(tile_host_t));
      if (ptr==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr)");
	closelog();
	exit(EXIT_FAILURE);
      }
      if (last!=NULL) last->next=ptr;
      
      tile_hostlist.nr++;
      len=strlen2(buffer);
      ptr->hostname=(char*)malloc(len+1);

      if (ptr->hostname==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr->hostname)");
	closelog();
	exit(EXIT_FAILURE);
      }      
      strncpy(ptr->hostname,buffer,len);
      ptr->hostname[len]='\0';
      last=ptr;
      ptr=ptr->next;      
    }
    fclose(fp);
    last->next=NULL;
    break;
  case PVM_ADDS_HOSTS:
    // use pvm to evaluate how many tasks at 
    // which hosts to start
    status = pvm_config( &nhost, &narch, &hostp );
    pvm_error(PVM_CONFIG,status,"<pvm_config> failed!\n");
   
    tile_hostlist.nr=nhost;
    last=NULL;

    for (i = 0; i < nhost; i++) {
      ptr=(tile_host_t*)malloc(sizeof(tile_host_t));      
      if (ptr==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr)");
	closelog();
	exit(EXIT_FAILURE);
      }
      if (last!=NULL) last->next=ptr;
      if (i==0) tile_hostlist.first_host=ptr; 
     
      len=strlen(hostp[i].hi_name)+1;
      ptr->hostname=(char*)malloc(len);
      if (ptr->hostname==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr->hostname)");
	closelog();
	exit(EXIT_FAILURE);
      }
      strcpy(ptr->hostname,hostp[i].hi_name);
      ptr->speed=hostp[i].hi_speed;
      last=ptr;
      ptr=ptr->next;
    }
    last->next=NULL;
#ifdef PVM_DEBUG
    fp=fopen("/tmp/pvmstuff.txt","a");   
    ptr=tile_hostlist.first_host;
    while (ptr!=NULL) {
      //for (i = 0; i < nhost; i++) {
      fprintf(fp,"Host to add: <%s>\n", ptr->hostname);
      ptr=ptr->next;
    }
    fclose(fp);
#endif
    break;
  default:
    // unknown parameter 
    return -1;
  }
  return tile_hostlist.nr;
}

// add_tile_hosts2pvm returns the number of hosts to add
int add_tile_hosts2pvm(int how) {
  struct pvmhostinfo *hostp;
  int i, nhost,narch,status,len;
  tile_host_t *ptr,*last;
  
  char buffer[100];

  __SET_DEBUG_FILE("/tmp/pvmstuff.txt");
  __DEBUG1("add_tile_hosts2pvm\n");

  switch (how) {
  case FILE_ADDS_HOSTS:
    // read file and get hostnames
    fp=fopen(PVM_HOSTFILE,"r");
    if (fp==NULL) {
      return -1;
    }
    tile_hostlist.nr=0;
    ptr=tile_hostlist.first_host;
    last=NULL;

    // read every line
    while (!feof(fp)) {
      fscanf(fp,"%s\n",buffer);
      ptr=(tile_host_t *)malloc(sizeof(tile_host_t));
      if (ptr==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr)");
	closelog();
	exit(EXIT_FAILURE);
      }
      if (last!=NULL) last->next=ptr;
      
      tile_hostlist.nr++;
      len=strlen2(buffer);
      ptr->hostname=(char*)malloc(len+1);

      if (ptr->hostname==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr->hostname)");
	closelog();
	exit(EXIT_FAILURE);
      }      
      strncpy(ptr->hostname,buffer,len);
      ptr->hostname[len]='\0';
      last=ptr;
      ptr=ptr->next;      
    }
    fclose(fp);
    last->next=NULL;
    break;
  case PVM_ADDS_HOSTS:
    // use pvm to evaluate how many tasks at 
    // which hosts to start
    status = pvm_config( &nhost, &narch, &hostp );
    pvm_error(PVM_CONFIG,status,"<pvm_config> failed!\n");
   
    tile_hostlist.nr=nhost;
    last=NULL;

    for (i = 0; i < nhost; i++) {
      ptr=(tile_host_t*)malloc(sizeof(tile_host_t));      
      if (ptr==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr)");
	closelog();
	exit(EXIT_FAILURE);
      }
      if (last!=NULL) last->next=ptr;
      if (i==0) tile_hostlist.first_host=ptr; 
     
      len=strlen(hostp[i].hi_name)+1;
      ptr->hostname=(char*)malloc(len);
      if (ptr->hostname==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (ptr->hostname)");
	closelog();
	exit(EXIT_FAILURE);
      }
      strcpy(ptr->hostname,hostp[i].hi_name);
      ptr->speed=hostp[i].hi_speed;
      last=ptr;
      ptr=ptr->next;
    }
    last->next=NULL;
#ifdef PVM_DEBUG
    fp=fopen("/tmp/pvmstuff.txt","a");   
    ptr=tile_hostlist.first_host;
    while (ptr!=NULL) {
      //for (i = 0; i < nhost; i++) {
      fprintf(fp,"Host to add: <%s>\n", ptr->hostname);
      ptr=ptr->next;
    }
    fclose(fp);
#endif
    break;
  default:
    // unknown parameter 
    return -1;
  }
  return tile_hostlist.nr;
}

void send_init_unicast(message *parameter, int *tid,double *pointx,double *pointy, double *pointz,double *gmatrix_inv,int nr_worker,int plen) {
  int i, worker,status;
  // initial part
  i=0;
  for (worker=0; worker<hostlist.nr; worker++) {	

    __DEBUG1("Send initial configuration\n");

    // send initial configuration
    status=pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkint((int*)&(parameter->int_message),sizeof(message_int)/sizeof(int),1);
    pvm_error(PVM_PKINT,status,"<pvm_pkint> failed for parameter->int_message!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    status=pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)&(parameter->double_message),sizeof(message_double)/sizeof(double),1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for parameter->double_message!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
  
    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)pointx,plen,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for pointx!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)pointy,plen,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for pointy!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)pointz,plen,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for pointz!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
	
    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)gmatrix_inv,(plen+1)*(plen+1),1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for gmatrix_inv!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
  }
}

void send_tile_init_unicast(double *lon,
			    double *lat,
			    double *z,
			    double *xgwork,
			    double *ygwork,
			    int *dog,
			    static_msg param,
			    size_msg param_size,
			    int *tid,
			    int nr_worker){
  int i, worker,status;
  // initial part
  i=0;
  for (worker=0; worker<tile_hostlist.nr; worker++) {	

    __DEBUG1("Send initial configuration\n");

    // send initial configuration
    status=pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkint((int*)&(param_size),sizeof(size_msg)/sizeof(int),1);
    pvm_error(PVM_PKINT,status,"<pvm_pkint> failed for param_size!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    status=pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkint((int*)&(param.i),sizeof(static_msg_i)/sizeof(int),1);
    pvm_error(PVM_PKINT,status,"<pvm_pkint> failed for param.i!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
  
    status=pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)&(param.d),sizeof(static_msg_d)/sizeof(double),1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for param.d!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
  
    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)lon,param_size.n,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for lon!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)lat,param_size.n,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for lat!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)z,param_size.n,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for z!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)xgwork,param_size.nx*param_size.ny,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for xgwork!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)ygwork,param_size.nx*param_size.ny,1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for ygwork!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkint((int*)dog,param_size.nx*param_size.ny,1);
    pvm_error(PVM_PKINT,status,"<pvm_pkint> failed for dog!\n");
    status=pvm_send(tid[worker],MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

  }
}

void send_init_multicast(message *parameter, int *tid,double *pointx,double *pointy, double *pointz,double *gmatrix_inv,int nr_worker,int plen) {
  // initial part
  int i, status;
  i=0;	
  __DEBUG1("Multicast: Send initial configuration\n");

  // send initial configuration
    status=pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkint((int*)&(parameter->int_message),sizeof(message_int)/sizeof(int),1);
    pvm_error(PVM_PKINT,status,"<pvm_pkint> failed for parameter->int_message!\n");
    status=pvm_mcast(tid,nr_worker,MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    status=pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    pvm_pkdouble((double*)&(parameter->double_message),sizeof(message_double)/sizeof(double),1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for parameter->double_message!\n");
    status=pvm_mcast(tid,nr_worker,MSGTAG_INITIALSEND);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
 
  pvm_initsend(PvmDataDefault);
  pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
  pvm_pkdouble((double*)pointx,plen,1);
  pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for pointx!\n");

  status=pvm_mcast(tid,nr_worker,MSGTAG_INITIALSEND);
  pvm_error(PVM_SEND,status,"<pvm_mcast> failed!\n");
	
  pvm_initsend(PvmDataDefault);
  pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
  pvm_pkdouble((double*)pointy,plen,1);
  pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for pointy!\n");

  status=pvm_mcast(tid,nr_worker,MSGTAG_INITIALSEND);
  pvm_error(PVM_SEND,status,"<pvm_mcast> failed!\n");


  pvm_initsend(PvmDataDefault);
  pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
  pvm_pkdouble((double*)pointz,plen,1);
  pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for pointz!\n");
  status=pvm_mcast(tid,nr_worker,MSGTAG_INITIALSEND);
  pvm_error(PVM_SEND,status,"<pvm_mcast> failed!\n");
  
  pvm_initsend(PvmDataDefault);
  pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
  pvm_pkdouble((double*)gmatrix_inv,(plen+1)*(plen+1),1);
  pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for gmatrix_inv!\n");

  status=pvm_mcast(tid,nr_worker,MSGTAG_INITIALSEND);
  pvm_error(PVM_SEND,status,"<pvm_mcast> failed!\n");
}


// return value is either 0 or -1. -1 in case
// of an error
int setjobdata_pending(int tid,double j) {
  // find host with the above given tid
  int i;
  host_t *ptr=hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for pending job
    ptr->pending=j;
    return 0;
  } else return -1;
}

int settilejobdata_pending(int tid,double j) {
  // find host with the above given tid
  int i;
  tile_host_t *ptr=tile_hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for pending job
    ptr->pending=j;
    return 0;
  } else return -1;
}

#ifdef LOG_STATISTIC
 
void logjobdata() {
  host_t *ptr=hostlist.first_host;
  FILE *f;
  
  f=fopen("/tmp/pvm_statlog.txt","a");
  if (f==NULL) return;	
 
  // write data for each and every host in the hostfile list.
  while (ptr!=NULL) {
    fprintf(f,"Hostname: %s,Speed: %d\n",ptr->hostname,ptr->speed);
    fprintf(f,"TID: %d\n",ptr->tid);
    fprintf(f,"Points: %10.0f\n",ptr->nr_points);
#ifdef USE_RDTSC
    fprintf(f,"Time(msec): %10.3f\n",tsc_to_ms(ptr->total_time));
    fprintf(f,"Avg_per_point: (msec): %5.8f\n",tsc_to_ms(ptr->total_time)/ptr->nr_points);
#else 
    fprintf(f,"Time(sec): %10.3f\n",(float)ptr->total_time);
    fprintf(f,"Avg_per_point: (sec): %5.8f\n",(float)ptr->total_time/ptr->nr_points);
#endif
    ptr=ptr->next; 
  }
  fclose(f);
  return;
}
#endif

#ifdef USE_RDTSC
int setjobdata_starttime(int tid,long long time_calc) {
#else
int setjobdata_starttime(int tid,time_t time_calc) { 
#endif
  // find host with the above given tid
  host_t *ptr=hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for pending job
    ptr->start=time_calc;
    return 0;
  } else return -1;
}

#ifdef USE_RDTSC
int settilejobdata_starttime(int tid,long long time_calc) {
#else
int settilejobdata_starttime(int tid,time_t time_calc) { 
#endif
  // find host with the above given tid
  tile_host_t *ptr=tile_hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for pending job
    ptr->start=time_calc;
    return 0;
  } else return -1;
}

#ifdef USE_RDTSC
int setjobdata_start(int tid,double pending, long long time_calc, job *jobptr) {
#else 
int setjobdata_start(int tid,double pending, time_t time_calc, job *jobptr) {
#endif

  // write history data
  if (setjobdata_starttime(tid,time_calc)==-1) {
    syslog(LOG_WARNING,"setjobdata_starttime failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }

  if (setjobdata_pending(tid,pending)==-1) {
    syslog(LOG_WARNING,"setjobdata_pending failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }

  if (setjobdata_lastjob(tid,jobptr)==-1) {
    syslog(LOG_WARNING,"setjobdata_lastjob failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }
  return 0;
}

#ifdef USE_RDTSC
int settilejobdata_start(int tid,double pending, long long time_calc, tjqueue_t *queueentry) {
#else 
int settilejobdata_start(int tid,double pending, time_t time_calc, tjqueue_t *queueentry) {
#endif

  // write history data
  if (settilejobdata_starttime(tid,time_calc)==-1) {
    syslog(LOG_WARNING,"settilejobdata_starttime failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }

  if (settilejobdata_pending(tid,pending)==-1) {
    syslog(LOG_WARNING,"settilejobdata_pending failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }

  if (set_last_queueentry(tid,queueentry)==-1) {
    syslog(LOG_WARNING,"settilejobdata_lastjob failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }
  return 0;
}

int setjobdata_init(char* hostname,int tid) {
  // find host with the above given tid
  host_t *ptr=hostlist.first_host;

  while ((ptr!=NULL) && (strcmp(ptr->hostname,hostname)!=0)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    ptr->tid=tid;
    ptr->total_time=0;
    ptr->last_job=NULL;
    ptr->nr_points=0;
    return 0;
  } else return -1;
}

int settilejobdata_init(char* hostname,int tid) {
  // find host with the above given tid
  tile_host_t *ptr=tile_hostlist.first_host;

  while ((ptr!=NULL) && (strcmp(ptr->hostname,hostname)!=0)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    ptr->tid=tid;
    ptr->total_time=0;
    ptr->last_queueentry=NULL;
    ptr->nr_points=0;
    return 0;
  } else return -1;
}

#ifdef USE_RDTSC 
void setjobdata_finish(int tid, long long time_calc) {
#else
void setjobdata_finish(int tid, time_t time_calc) {
#endif
  if (setjobdata_endtime(tid,time_calc)==-1) {
    syslog(LOG_WARNING,"setjobdata_endtime failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }
}

#ifdef USE_RDTSC 
void settilejobdata_finish(int tid, long long time_calc) {
#else
void settilejobdata_finish(int tid, time_t time_calc) {
#endif
  if (settilejobdata_endtime(tid,time_calc)==-1) {
    syslog(LOG_WARNING,"settilejobdata_endtime failed - unable to find tid");
    closelog();
    exit(EXIT_FAILURE);
  }
}

#ifdef USE_RDTSC
int setjobdata_endtime(int tid,long long time_calc) {
#else
int setjobdata_endtime(int tid,time_t time_calc) {
#endif
  // find host with the above given tid
  host_t *ptr=hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for end time
    //ptr->end=time_calc;
    // update statistics
    ptr->nr_points+=ptr->pending;
    // no points pending anymore
    ptr->total_time+=(time_calc-ptr->start);
    ptr->pending=0;
    // job is done - delete it
    ptr->last_job=NULL;
    return 0;
  } else return -1;
}

#ifdef USE_RDTSC
int settilejobdata_endtime(int tid,long long time_calc) {
#else
int settilejobdata_endtime(int tid,time_t time_calc) {
#endif
  // find host with the above given tid
  tile_host_t *ptr=tile_hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for end time
    //ptr->end=time_calc;
    // update statistics
    ptr->nr_points+=ptr->pending;
    // no points pending anymore
    ptr->total_time+=(time_calc-ptr->start);
    ptr->pending=0;
    // job is done - delete it
    ptr->last_queueentry=NULL;
    return 0;
  } else return -1;
}

int setjobdata_lastjob(int tid,job *jobptr) {
  // find host with the above given tid
  host_t *ptr=hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for  job
    ptr->last_job=jobptr;
    return 0;
  } else return -1;
}


int set_last_queueentry(int tid,tjqueue_t *queueentry) {
  // find host with the above given tid
  tile_host_t *ptr=tile_hostlist.first_host;

  while ((ptr!=NULL) && (ptr->tid!=tid)) ptr=ptr->next;
  
  if (ptr!=NULL) {
    // set value for  job
    ptr->last_queueentry=queueentry;
    return 0;
  } else return -1;
}

// queue_addjob returns 
// -1 in case of no memory
// 0 otherwise
// memory for job is created outside function
int queue_addjob(job_queue_t *job_queue,job* jobptr) {
  jqueue_t *ptr=job_queue->first;

  while (ptr!=NULL) ptr=ptr->next;  // move to the tail

  ptr=(jqueue_t*)malloc(sizeof(jqueue_t));
  if (ptr==NULL) return -1; // not enough memory
  ptr->jobptr=jobptr; 
  ptr->next=NULL;
  job_queue->nr++;
  return 0;
}


int queue_queryjob(job_queue_t *job_queue,int id,job** jobptr) {
  jqueue_t *ptr=job_queue->first;

  while ((ptr!=NULL) && (ptr->jobptr->id!=id)) ptr=ptr->next;  // move to the tail

  if (ptr==NULL) return -1; // element not found
  *jobptr=ptr->jobptr;
  return 0;
}

// fifo removement
int queue_removejob(job_queue_t *job_queue,job** jobptr) {
  jqueue_t *ptr=job_queue->first;

  if (ptr==NULL) return -1; // not jobs queued
  else {
    *jobptr=ptr->jobptr;
    job_queue->first=ptr->next;
    ptr->jobptr=NULL;
    free(job_queue->first);
  }
  job_queue->nr--;
  return 0;
}

// pvm_krige is executed by pvm_server.c after all data is received from R
// the main purpose of this function is to start the pvm_clients and to do the job handling
void pvm_krige(double *pointx,double *pointy, double *pointz, long plen, double *sx, double *sy, long slen,
		 double *zhat, double *sigma2hat, int model, double param0,double param1, double param2, double *gmatrix_inv, 
		 double *gvector, double *dst, double *lambda_hat, double *sdo)
{
  int i,j,k,worker,resolve; //x,total_work=dim_spalte,resolve;
  int jobs_pending=0,id_counter=0,cc,bytes_sent;
  int proceed,recvmsgtag,singletid;
  int *tid;
  host_t host;
  int points_to_send;
  job_queue_t job_queue; 
  job **joblist;
  result **resultlist;  
  job *jobptr;
  //host_t *hostptr;
  result *resptr;
  message parameter;
  int status,single_tid;
  host_t *hostptr;
  //job_history *jobhist;
  //clock_t time_calc;
  int nr_worker;
#ifdef PVM_DEBUG
  int x;
#endif

  //  init 
  job_queue.first=NULL;
  job_queue.nr=0;
  parameter.int_message.plen=plen;
  parameter.int_message.slen=slen;
  parameter.int_message.model=model;
  parameter.double_message.param0=param0;
  parameter.double_message.param1=param1;
  parameter.double_message.param2=param2;
 
  openlog("pvm_server",LOG_PID|LOG_ODELAY,LOG_DAEMON);  

  __DEBUG1("Entry pvm_krige...\n");

  // array of pointers to jobs sent to clients - 
  // we have to keep track of those because the results are not returned
    // in their inital order
  joblist=(job**)malloc(sizeof(job*)*((slen/POINTS_TO_SEND)+1));
  if (joblist==NULL) {
    syslog(LOG_WARNING,"Memory allocation problem (joblist)");
    closelog();
    exit(EXIT_FAILURE);
  }
  resultlist=(result**)malloc(sizeof(result*)*((slen/POINTS_TO_SEND)+1));
  if (resultlist==NULL) {
    syslog(LOG_WARNING,"Memory allocation problem (resultlist)");
    closelog();
    exit(EXIT_FAILURE);
  }
  for (i=0; i<((slen/POINTS_TO_SEND)+1); i++) {
    joblist[i]=NULL;
    resultlist[i]=NULL;
  }
    
  fp=fopen(PVM_HOSTFILE,"r");
  if (fp==NULL) {
    __DEBUG1("No pvm_hosts file found - use pvm configuration\n");

    // file does not exit --> we use pvm to 
    // add hosts to the file
    status=add_hosts2pvm(PVM_ADDS_HOSTS);
  } else {
    fclose(fp);
    __DEBUG1("Found pvm_hosts file!\n");
    // if file exits - read it and call pvm_addhosts
    status=add_hosts2pvm(FILE_ADDS_HOSTS );
  }
  if (status<=0) {
    // adding some workers failed
    syslog(LOG_WARNING,"Unable to find any hosts to add!");
    exit(EXIT_FAILURE);
  }
  
  tid=(int*)malloc(sizeof(int)*hostlist.nr);
  if (tid==NULL) {
    syslog(LOG_WARNING,"Memory allocation problems (tid)!");
    exit(EXIT_FAILURE);
  }
  // not done yet: need to supply a vector with hostnames instead of pvmtaskdefault
  hostptr=hostlist.first_host;

  // start each client individually to make a direct connection between hostname and tid 
  for (i=0; i<hostlist.nr; i++) {
    //status=pvm_spawn(CLIENT_TO_START, (char**)0, PvmTaskDefault, (char*)0, hostlist.nr, tid);
    status=pvm_spawn(CLIENT_TO_START, (char**)0, PvmTaskHost,hostptr->hostname, 1, &singletid);
    pvm_error(PVM_SPAWN,status,"<pvm_spawn> failed - unable to add client!\n");  
    tid[i]=singletid;
    if (setjobdata_init(hostptr->hostname,singletid)==-1) {
      syslog(LOG_WARNING,"setjobdata_init failed - could not find hostname");
      closelog();
      exit(EXIT_FAILURE);
    }
    // add notifications
    status=pvm_notify(PvmTaskExit,MSGTAG_TASKDIED,1,&singletid);
    pvm_error(PVM_NOTIFY,status,"<pvm_notify - PvmTaskExit> failed!\n");  
    
    status=pvm_notify(PvmHostDelete,MSGTAG_HOSTDELETE,1,&singletid);
    pvm_error(PVM_NOTIFY,status,"<pvm_notify - PvmHostDelete> failed!\n");  
    
    status=pvm_notify(PvmHostAdd,MSGTAG_HOSTADD,1,&singletid);
    pvm_error(PVM_NOTIFY,status,"<pvm_notify - PvmHostAdd> failed!\n");  
    hostptr=hostptr->next;
  } 
  
  __DEBUG2("Spawned clients # %d\n",hostlist.nr);


#ifdef PVM_DEBUG
  /*
  fp=fopen("/tmp/pvmstuff.txt",WRITE_MODE);
  fprintf(fp,"Clients: \n");
  for (i=0; i<hostlist.nr; i++)
    fprintf(fp,"Spawned client: t%x\n",tid[i]);	
  fclose(fp);
  */
#endif

  // send configuration to client
#ifdef USE_MULTICAST 
  send_init_multicast(&parameter,tid,pointx,pointy,pointz,gmatrix_inv,
  	hostlist.nr,plen);
#else
  send_init_unicast(&parameter,tid,pointx,pointy,pointz,gmatrix_inv,
  	hostlist.nr,plen);  
#endif

  // initial data points are always send unicast
  i=0;
  for (worker=0; worker<hostlist.nr; worker++) {	
    __DEBUG1("Send initial data points\n");

    // send first data points
    // i scans the s vector to see which points to send 
    // or not (based on sdo)
    // j keeps track of the myjob record
    jobptr=joblist[id_counter]=(job*)malloc(sizeof(job));
    if (jobptr==NULL) {
      syslog(LOG_WARNING,"Memory allocation problem (jobptr)");
      closelog();
      pvm_exit();
      exit(EXIT_FAILURE);
    }
    j=0;
    while (j<POINTS_TO_SEND && i<slen) {
      if (!sdo[i]) {
 	zhat[i]=-1.0;  // equal to NA
	sigma2hat[i]=-1.0; // NA	    
      } else { 
	jobptr->sx[j]=sx[i];
	jobptr->sy[j]=sy[i];	     
	j++;
      }
      i++;
    }

    jobptr->nr_points=j;
    jobptr->id=id_counter;
    id_counter++;
    jobs_pending++;
    
    // send job
    pvm_initsend(PvmDataDefault);
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");		
    pvm_pkdouble((double*)jobptr,sizeof(job)/sizeof(double),1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for jobptr!\n");

    pvm_send(tid[worker],MSGTAG_SENDJOB);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
    
    // write history data
#ifdef USE_RDTSC
   setjobdata_start(tid[worker],(double)jobptr->nr_points,rdtsc(),jobptr);
#else
    setjobdata_start(tid[worker],(double)jobptr->nr_points,time(NULL),jobptr);
#endif

#ifdef PVM_DEBUG	  
    fp=fopen("/tmp/pvm_jobs.txt",WRITE_MODE);
//    fprintf(fp,"JOBNR: %d\n",id_counter);
    for (j=0; j<jobptr->nr_points; j++) {
//      fprintf(fp,"sx[%d]=%f, sy[%d]=%f\n",j,jobptr->sx[j],j,jobptr->sy[j]);    
      fprintf(fp,"sx=%f, sy=%f\n",jobptr->sx[j],jobptr->sy[j]);    
    }
    //fprintf(fp,"Initial - total number of points: %d\n",jobptr->nr_points);    
    fclose(fp);
#endif
  } // end initial part

  // Receive - Send 
  __DEBUG1("\nInitial part finished! - enter receive - send.\n");
	
  // deal with the remaining points
  while (i<slen) {
    // allocate memory for results
    resptr=(result*)malloc(sizeof(result));
    if (resptr==NULL) {
      syslog(LOG_WARNING,"Memory allocation problem (resptr)");
      closelog();
      pvm_exit();
      exit(EXIT_FAILURE);
    }
    //    cc = pvm_recv(-1,999);
    do { 
      // we only leave this loop if we got some results
      // all other messages are handled immediately
      // receive any message tag from any process
      cc = pvm_recv(-1,-1); 
      pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
      status=pvm_upkdouble((double*)resptr,sizeof(result)/sizeof(double),1);
      pvm_error(PVM_UPKDOUBLE,status,"<pvm_upkdouble> failed for resptr!\n");
      status=pvm_bufinfo(cc, &bytes_sent, &recvmsgtag, &resolve);
      pvm_error(PVM_BUFINFO,status,"<pvm_bufinfo> failed!\n");

      // evaluate message tag
      // todo - need to determine what to do 
      // at each message tag.
      switch(recvmsgtag){
      case MSGTAG_KRIGE:
	proceed=0;
#ifdef USE_RDTSC
	setjobdata_finish(resolve,rdtsc());
#else
        setjobdata_finish(resolve,time(NULL));
#endif
	break;
      case MSGTAG_TASKDIED:	
	// find host
	hostptr=hostlist.first_host;
	while ((hostptr!=NULL) && (hostptr->tid!=resolve)) hostptr=hostptr->next;

	if (hostptr==NULL) { // tid not found
	  syslog(LOG_WARNING,"HOSTDELETE: tid(%d) not found!",resolve);
	  closelog();
	  pvm_exit();
	  exit(EXIT_FAILURE);
	}
	// get lastjob - if there was one
	if  (hostptr->last_job!=NULL) {
	  if (queue_addjob(&job_queue,hostptr->last_job)==-1) { // not enough memory
	    syslog(LOG_WARNING,"Memory allocation problem (queue_addjob())");
	    closelog();
	    pvm_exit();
	    exit(EXIT_FAILURE);
	  }
	  hostptr->last_job=NULL; 
	  hostptr->status=HOST_STATUS_TASKDIED;
	}
	jobs_pending--;
	// try to restart task?
	break;
      case MSGTAG_HOSTDELETE:
	// remove host from hostlist
	// find host
	hostptr=hostlist.first_host;
	while ((hostptr!=NULL) && (hostptr->tid!=resolve)) hostptr=hostptr->next;

	if (hostptr==NULL) { // tid not found
	  syslog(LOG_WARNING,"TASKDIED: tid(%d) not found!");
	  closelog();
	  pvm_exit();
	  exit(EXIT_FAILURE);
	}
	// get lastjob - if there was one
	if (hostptr->last_job!=NULL) {
	  if (queue_addjob(&job_queue,hostptr->last_job)==-1) { // not enough memory
	    syslog(LOG_WARNING,"Memory allocation problem (queue_addjob())",resolve);
	    closelog();
	    pvm_exit();
	    exit(EXIT_FAILURE);
	  }
	  hostptr->last_job=NULL; 
	  hostptr->status=HOST_STATUS_HOSTDELETE;
	}
	jobs_pending--;
	break;
      case  MSGTAG_HOSTADD:
	// add host to hostlist and
	// send him the initial information

	break;
      default:
	syslog(LOG_WARNING,"Unknown message tag received");
	closelog();
	pvm_exit();
	exit(EXIT_FAILURE);
      }
    } while (proceed==-1);
    jobs_pending--;
    proceed=-1;

    __DEBUG3("Got result (%d - bytes)- id: %d.\n",bytes_sent,resptr->id);


#ifdef PVM_DEBUG
    fp=fopen("/tmp/pvmstuff_results.txt",WRITE_MODE);
    fprintf(fp,"Result: id-%d,nr of points: %d.\n",resptr->id,resptr->nr_points);
    for (x=0; x<resptr->nr_points; x++) {
      fprintf(fp,"zhat[%d]=%f  sigma2hat[%d]=%f\n",x,resptr->zhat[x],x,resptr->sigma2hat[x]);
    }
    fclose(fp);
#endif

    // add result to the list
    // the id of the result is the same as the id of the given job
    //if (resptr->id>=0 && resptr->id<id_counter) 
    resultlist[(int)resptr->id]=resptr;
    
    if (job_queue.nr>0) {
      // some jobs pending because of crashed clients
      __DEBUG1("Use pending job!\n");

      if (queue_removejob(&job_queue,&jobptr)==-1) {
	syslog(LOG_WARNING,"No jobs queued!)");
	closelog();
	pvm_exit();
	exit(EXIT_FAILURE);	
      }
      //jobs_pending++;
    } else {
      __DEBUG1("Create new job!\n");

      // create a new job
      jobptr=joblist[id_counter]=(job*)malloc(sizeof(job));
      if (jobptr==NULL) {
	syslog(LOG_WARNING,"Memory allocation problem (jobptr)");
	closelog();
	pvm_exit();
	exit(EXIT_FAILURE);
      }
      //id_counter++;
    
      j=0;
      while (j<POINTS_TO_SEND && i<slen) { 
	if (!sdo[i]) {
	  zhat[i]=-1.0;  // equal to NA
	  sigma2hat[i]=-1.0; // NA	    
	} else { 
	  zhat[i]=0; // equal to not assigned yet
	  jobptr->sx[j]=sx[i];
	  jobptr->sy[j]=sy[i];	     
	  j++;	    
	}
	i++;
      }

      jobptr->nr_points=j;
    
    
      jobptr->id=id_counter;
      id_counter++;
      //jobs_pending++;

#ifdef PVM_DEBUG	  
      fp=fopen("/tmp/pvm_jobs.txt",WRITE_MODE);
      //    fprintf(fp,"JOBNR: %d\n",id_counter);
      for (j=0; j<jobptr->nr_points; j++) {
	//     fprintf(fp,"sx[%d]=%f, sy[%d]=%f\n",j,jobptr->sx[j],j,jobptr->sy[j]);    
	fprintf(fp,"sx=%f, sy=%f\n",jobptr->sx[j],jobptr->sy[j]);    
      }
      //    fprintf(fp,"Inital - total number of points: %d\n",jobptr->nr_points);    
      fclose(fp);
#endif
    }
    jobs_pending++; 
    __DEBUG1("Send job!\n");

    // send job
    status=pvm_initsend(PvmDataDefault);		
    pvm_error(PVM_INITSEND,status,"<pvm_initsend> failed!\n");
    status=pvm_pkdouble((double*)jobptr,sizeof(job)/sizeof(double),1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for jobptr!\n");
    status=pvm_send(resolve,MSGTAG_SENDJOB);
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");

    // write history data
#ifdef USE_RDTSC
    if (setjobdata_start(resolve,(double)j,rdtsc(),jobptr)==-1) {
#else
    if (setjobdata_start(resolve,(double)j,time(NULL),jobptr)==-1) {
#endif
    syslog(LOG_WARNING,"setjobdata_init failed - could not find hostname");
      closelog();
      exit(EXIT_FAILURE);
    }
      
#ifdef PVM_DEBUG	  
    fp=fopen("/tmp/pvmstuff.txt",WRITE_MODE);
    
    for (j=0; j<jobptr->nr_points; j++) {
      fprintf(fp,"sx[%d]=%f, sy[%d]=%f\n",j,jobptr->sx[j],j,jobptr->sy[j]);	        
    }  
    fprintf(fp,"Total number of points for job %d: %d",jobptr->nr_points,id_counter-1);  
    fclose(fp);
#endif
  } // end while - no more points to send

  __DEBUG1("\n-----------------------------------------------\n");
  __DEBUG1("Wait for remaining results to arrive\n");
  __DEBUG1("\n-----------------------------------------------\n");

  // wait for remaining results to arrive
  while (jobs_pending>0) {
    resptr=(result*)malloc(sizeof(result));
    if (resptr==NULL) {
      syslog(LOG_WARNING,"Memory allocation problem (resptr)");
      closelog();
      pvm_exit();
      exit(EXIT_FAILURE);
    }

    cc = pvm_recv(-1,-1); 	
    pvm_error(PVM_RECV,cc,"<pvm_recv> failed!\n");
    status=pvm_upkdouble((double*)resptr,sizeof(result)/sizeof(double),1);
    pvm_error(PVM_PKDOUBLE,status,"<pvm_pkdouble> failed for resptr!\n");
    status=pvm_bufinfo(cc, &bytes_sent, (int*)0, &resolve);
    pvm_error(PVM_BUFINFO,status,"<pvm_bufinfo> failed!\n");
    jobs_pending--;

#ifdef USE_RDTSC 
    setjobdata_finish(resolve,rdtsc());
#else
    setjobdata_finish(resolve,time(NULL));
#endif

    // add result to the list
    // the id of the result is the same as the id of the given job
    //if (resptr->id>=0 && resptr->id<id_counter) {     
    resultlist[(int)resptr->id]=resptr;
    __DEBUG3("Got result (%d - bytes)- id: %d.\n",bytes_sent,resptr->id);

#ifdef PVM_DEBUG
    fp=fopen("/tmp/pvmstuff_results.txt",WRITE_MODE);
    fprintf(fp,"Result: id-%d,nr of points: %d.\n",resptr->id,resptr->nr_points);
    for (x=0; x<resptr->nr_points; x++) {
      fprintf(fp,"zhat[%d]=%f\n",x,resptr->zhat[x]);
      fprintf(fp,"sigma2hat[%d]=%f\n",x,resptr->sigma2hat[x]);
    }      
    fclose(fp);
#endif
    /*} else {
      __DEBUG1("Fatal error: result list not linked properly.\n");
      // is it possible to happen ???
      pvm_exit();
      exit(EXIT_FAILURE);
    }*/     
  }

  __DEBUG2("\nAll jobs finished (i=%d)- going to kill pvm_clients.",i);
  __DEBUG2("\nStatistics: number of jobs: %d",id_counter);


  // kill pvm_clients 
  for (worker=0; worker<hostlist.nr; worker++) {
    status=pvm_kill(tid[worker]);  
    pvm_error(PVM_SEND,status,"<pvm_send> failed!\n");
  }

#ifdef LOG_STATISTIC
  logjobdata();
#endif
  __DEBUG1("\nReconstruct matrix.\n");
				

#ifdef PVM_DEBUG
  fp=fopen("/tmp/pvmstuff.txt",WRITE_MODE);
#endif
  j=0; // iterates over zhat
  i=0; // points to resultlists
  k=0; // pointer within a structure list
  resptr=resultlist[i];
#ifdef PVM_DEBUG
  fprintf(fp,"Resultlist=%d\n",i);
  fprintf(fp,"Nr of points: %d\n",resptr->nr_points);
#endif
  while (j<slen) {
    if (zhat[j]!=-1) { // no NA value
      // get point from result structure
      if (k<resptr->nr_points) {
	zhat[j]=resptr->zhat[k];
	sigma2hat[j]=resptr->sigma2hat[k];
#ifdef PVM_DEBUG       
	fprintf(fp,"      k=%d\n",k);
	fprintf(fp,"      zhat[%d]=%f\n",j,resptr->zhat[k]);
	fprintf(fp,"      sigma2hat[%d]=%f\n",j,resptr->sigma2hat[k]);        
#endif
	k++;
      } else {
#ifdef PVM_DEBUG       
	fprintf(fp,"Skip to next resultarray\n");
#endif 
	k=0;
	i++;
	resptr=resultlist[i]; 	  
	j--; // error correction for j++ below
#ifdef PVM_DEBUG
	fprintf(fp,"Resultlist=%d\n",i);
	fprintf(fp,"Nr of points: %d\n",resptr->nr_points);
#endif
      }
    } 
#ifdef PVM_DEBUG       
    else {
      fprintf(fp,"      Skip point %d - NA-value\n",j);   
    }
#endif 
    
    j++;
  }
#ifdef PVM_DEBUG
  fprintf(fp,"pvm_krige finished !\n");
  fclose(fp);
#endif           
  closelog();
}
