/*
    RawSpeed - RAW file decoder.

    Copyright (C) 2009-2014 Klaus Post
    Copyright (C) 2014 Pedro Côrte-Real

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "common/Common.h"                      // for uint32, uchar8
#include "common/RawImage.h"                    // for RawImage
#include "decompressors/AbstractDecompressor.h" // for AbstractDecompressor
#include "decompressors/HuffmanTable.h"         // for HuffmanTable
#include "io/BitPumpJPEG.h"                     // for BitPumpJPEG
#include "io/Buffer.h"                          // for Buffer
#include "io/ByteStream.h"                      // for ByteStream
#include <array>                                // for array
#include <memory>                               // for unique_ptr

namespace rawspeed {

class CrwDecompressor final : public AbstractDecompressor {
  using crw_hts = std::array<std::array<HuffmanTable, 2>, 2>;

  RawImage mRaw;
  crw_hts mHuff;
  const bool lowbits;
  const Buffer mFile;

public:
  CrwDecompressor(const RawImage& img, uint32 dec_table_, bool lowbits_,
                  const Buffer* file);

  void decompress() const;

private:
  static HuffmanTable makeDecoder(const uchar8* ncpl, const uchar8* values);
  static crw_hts initHuffTables(uint32 table);

  inline static void decodeBlock(std::array<int, 64>* diffBuf,
                                 const crw_hts& mHuff, BitPumpJPEG* lPump,
                                 BitPumpJPEG* iPump);
};

} // namespace rawspeed
