static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Author: Shuji Narazaki <narazaki@InetQ.or.jp>                              \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_value_propagate_mode)                                        \n"
"  enum_value (GEGL_VALUE_PROPAGATE_MODE_WHITE, \"white\", N_(\"More white (larger value)\"))\n"
"  enum_value (GEGL_VALUE_PROPAGATE_MODE_BLACK, \"black\", N_(\"More black (smaller value)\"))\n"
"  enum_value (GEGL_VALUE_PROPAGATE_MODE_MIDDLE, \"middle\", N_(\"Middle value to peaks\"))\n"
"  enum_value (GEGL_VALUE_PROPAGATE_MODE_COLOR_PEAK, \"color_peak\", N_(\"Color to peaks\"))\n"
"  enum_value (GEGL_VALUE_PROPAGATE_MODE_COLOR, \"color\", N_(\"Only color\")) \n"
"  enum_value (GEGL_VALUE_PROPAGATE_MODE_OPAQUE, \"opaque\", N_(\"More opaque\"))\n"
"  enum_value (GEGL_VALUE_PROPAGATE_MODE_TRANSPARENT, \"transparent\", N_(\"More transparent\"))\n"
"enum_end (GeglValuePropagateMode)                                             \n"
"                                                                              \n"
"property_enum (mode, _(\"Mode\"),                                             \n"
"               GeglValuePropagateMode, gegl_value_propagate_mode,             \n"
"               GEGL_VALUE_PROPAGATE_MODE_WHITE)                               \n"
"  description (_(\"Mode of value propagation\"))                              \n"
"                                                                              \n"
"property_double (lower_threshold, _(\"Lower threshold\"), 0.0)                \n"
"    description (_(\"Lower threshold\"))                                      \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (upper_threshold, _(\"Upper threshold\"), 1.0)                \n"
"    description (_(\"Upper threshold\"))                                      \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double (rate, _(\"Propagating rate\"), 1.0)                          \n"
"    description (_(\"Upper threshold\"))                                      \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_color   (color, _(\"Color\"), \"blue\")                              \n"
"     description (_(\"Color to use for the \\\"Only color\\\" and \\\"Color to peaks\\\" modes\"))\n"
"     ui_meta     (\"role\", \"color-primary\")                                \n"
"                                                                              \n"
"property_boolean (top, _(\"To top\"), TRUE)                                   \n"
"     description (_(\"Propagate to top\"))                                    \n"
"                                                                              \n"
"property_boolean (left, _(\"To left\"), TRUE)                                 \n"
"     description (_(\"Propagate to left\"))                                   \n"
"                                                                              \n"
"property_boolean (right, _(\"To right\"), TRUE)                               \n"
"     description (_(\"Propagate to right\"))                                  \n"
"                                                                              \n"
"property_boolean (bottom, _(\"To bottom\"), TRUE)                             \n"
"     description (_(\"Propagate to bottom\"))                                 \n"
"                                                                              \n"
"property_boolean (value, _(\"Propagating value channel\"), TRUE)              \n"
"     description (_(\"Propagating value channel\"))                           \n"
"                                                                              \n"
"property_boolean (alpha, _(\"Propagating alpha channel\"), TRUE)              \n"
"     description (_(\"Propagating alpha channel\"))                           \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME     value_propagate                                      \n"
"#define GEGL_OP_C_SOURCE value-propagate.c                                    \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define SQR(x) ((x)*(x))                                                      \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint offset_left;                                                           \n"
"  gint offset_top;                                                            \n"
"  gint offset_right;                                                          \n"
"  gint offset_bottom;                                                         \n"
"} VPParamsType;                                                               \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gfloat  original_value;                                                     \n"
"  gshort  min_modified;                                                       \n"
"  gshort  max_modified;                                                       \n"
"  gfloat  max[3];                                                             \n"
"  gfloat  min[3];                                                             \n"
"  gfloat  maxv;                                                               \n"
"  gfloat  minv;                                                               \n"
"} MiddlePacket;                                                               \n"
"                                                                              \n"
"static inline gfloat                                                          \n"
"square_pixel (gfloat *pixel)                                                  \n"
"{                                                                             \n"
"  gfloat square = 0.0;                                                        \n"
"  gint   b;                                                                   \n"
"                                                                              \n"
"  for (b = 0; b < 3; b++)                                                     \n"
"    square += SQR(pixel[b]);                                                  \n"
"                                                                              \n"
"  return square;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gint                                                            \n"
"get_pixel_neighbors (gfloat        *buffer,                                   \n"
"                     gint           x,                                        \n"
"                     gint           y,                                        \n"
"                     gint           width,                                    \n"
"                     VPParamsType  *params,                                   \n"
"                     gfloat       **neighbors)                                \n"
"{                                                                             \n"
"  gint n_neighbors = 0;                                                       \n"
"  gint dx;                                                                    \n"
"                                                                              \n"
"  if (params->offset_top == -1)                                               \n"
"    for (dx = params->offset_left; dx <= params->offset_right; dx++)          \n"
"      {                                                                       \n"
"        neighbors[n_neighbors] = buffer + (x + dx + (y - 1) * width) * 4;     \n"
"        n_neighbors++;                                                        \n"
"      }                                                                       \n"
"                                                                              \n"
"  for (dx = params->offset_left; dx <= params->offset_right; dx++)            \n"
"    if (dx != 0)                                                              \n"
"      {                                                                       \n"
"        neighbors[n_neighbors] = buffer + (x + dx + y * width) * 4;           \n"
"        n_neighbors++;                                                        \n"
"      }                                                                       \n"
"                                                                              \n"
"  if (params->offset_bottom == 1)                                             \n"
"    for (dx = params->offset_left; dx <= params->offset_right; dx++)          \n"
"      {                                                                       \n"
"        neighbors[n_neighbors] = buffer + (x + dx + (y + 1) * width) * 4;     \n"
"        n_neighbors++;                                                        \n"
"      }                                                                       \n"
"                                                                              \n"
"  return n_neighbors;                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static inline gint                                                            \n"
"value_difference_check (gfloat *pixel1,                                       \n"
"                        gfloat *pixel2,                                       \n"
"                        gfloat upper_threshold,                               \n"
"                        gfloat lower_threshold)                               \n"
"{                                                                             \n"
"  gfloat diff;                                                                \n"
"  gint   i;                                                                   \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    {                                                                         \n"
"      diff = fabs (pixel1[i] - pixel2[i]);                                    \n"
"      if (! ((lower_threshold <= diff) && (diff <= upper_threshold)))         \n"
"        return 0;                                                             \n"
"    }                                                                         \n"
"  return 1;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"set_pixel (gfloat         *pixel,                                             \n"
"           gfloat         *best,                                              \n"
"           gfloat         *dst_buf,                                           \n"
"           gint            idx,                                               \n"
"           GeglProperties *o)                                                 \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  if (o->value)                                                               \n"
"    for (i = 0; i < 3; i++)                                                   \n"
"      dst_buf[idx + i] = o->rate * best[i] + (1.0 - o->rate) * pixel[i];      \n"
"  else                                                                        \n"
"    for (i = 0; i < 3; i++)                                                   \n"
"      dst_buf[idx + i] = pixel[i];                                            \n"
"                                                                              \n"
"  if (o->alpha)                                                               \n"
"    dst_buf[idx + 3] = o->rate * best[3] + (1.0 - o->rate) * pixel[3];        \n"
"  else                                                                        \n"
"    dst_buf[idx + 3] = pixel[3];                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"propagate_white (gfloat  *pixel,                                              \n"
"                 gfloat **neighbors,                                          \n"
"                 gint     n_neighbors,                                        \n"
"                 gfloat  *dst_buf,                                            \n"
"                 gint     idx,                                                \n"
"                 GeglProperties *o)                                           \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gfloat best[4], tmp;                                                        \n"
"  gfloat sqr_px = square_pixel (pixel);                                       \n"
"                                                                              \n"
"  memcpy (best, pixel, sizeof (gfloat) * 4);                                  \n"
"                                                                              \n"
"  for (i = 0; i < n_neighbors; i++)                                           \n"
"    {                                                                         \n"
"      tmp = square_pixel (neighbors[i]);                                      \n"
"                                                                              \n"
"      if (sqr_px < tmp &&                                                     \n"
"          value_difference_check (pixel, neighbors[i], o->upper_threshold, o->lower_threshold))\n"
"        {                                                                     \n"
"          sqr_px = tmp;                                                       \n"
"          memcpy (best, neighbors[i], sizeof (gfloat) * 3);                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  set_pixel (pixel, best, dst_buf, idx, o);                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"propagate_black (gfloat  *pixel,                                              \n"
"                 gfloat **neighbors,                                          \n"
"                 gint     n_neighbors,                                        \n"
"                 gfloat  *dst_buf,                                            \n"
"                 gint     idx,                                                \n"
"                 GeglProperties *o)                                           \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gfloat best[4], tmp;                                                        \n"
"  gfloat sqr_px = square_pixel (pixel);                                       \n"
"                                                                              \n"
"  memcpy (best, pixel, sizeof (gfloat) * 4);                                  \n"
"                                                                              \n"
"  for (i = 0; i < n_neighbors; i++)                                           \n"
"    {                                                                         \n"
"      tmp = square_pixel (neighbors[i]);                                      \n"
"                                                                              \n"
"      if (sqr_px > tmp &&                                                     \n"
"          value_difference_check (pixel, neighbors[i], o->upper_threshold, o->lower_threshold))\n"
"        {                                                                     \n"
"          sqr_px = tmp;                                                       \n"
"          memcpy (best, neighbors[i], sizeof (gfloat) * 3);                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  set_pixel (pixel, best, dst_buf, idx, o);                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"propagate_middle (gfloat  *pixel,                                             \n"
"                  gfloat **neighbors,                                         \n"
"                  gint     n_neighbors,                                       \n"
"                  gfloat  *dst_buf,                                           \n"
"                  gint     idx,                                               \n"
"                  GeglProperties *o)                                          \n"
"{                                                                             \n"
"  gint   i, vdc;                                                              \n"
"  gfloat best[4], tmp;                                                        \n"
"  MiddlePacket mp;                                                            \n"
"                                                                              \n"
"  gint peak_max = 1;                                                          \n"
"  gint peak_min = 1;                                                          \n"
"  gint peak_includes_equals = 1;                                              \n"
"                                                                              \n"
"  memcpy (best, pixel, sizeof (gfloat) * 4);                                  \n"
"                                                                              \n"
"  mp.original_value = mp.minv = mp.maxv = square_pixel (pixel);               \n"
"  mp.min_modified = mp.max_modified = 0;                                      \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    mp.min[i] = mp.max[i] = pixel[i];                                         \n"
"                                                                              \n"
"  for (i = 0; i < n_neighbors; i++)                                           \n"
"    {                                                                         \n"
"      tmp = square_pixel (neighbors[i]);                                      \n"
"      vdc = value_difference_check (pixel, neighbors[i], o->upper_threshold, o->lower_threshold);\n"
"                                                                              \n"
"      if ((tmp <= mp.minv) && vdc)                                            \n"
"        {                                                                     \n"
"          mp.minv = tmp;                                                      \n"
"          memcpy (mp.min, neighbors[i], sizeof (gfloat) * 3);                 \n"
"          mp.min_modified = 1;                                                \n"
"        }                                                                     \n"
"      if ((mp.maxv <= tmp) && vdc)                                            \n"
"        {                                                                     \n"
"          mp.maxv = tmp;                                                      \n"
"          memcpy (mp.max, neighbors[i], sizeof (gfloat) * 3);                 \n"
"          mp.max_modified = 1;                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (! ((peak_min & (mp.minv == mp.original_value))                          \n"
"         || (peak_max & (mp.maxv == mp.original_value))))                     \n"
"    return;                                                                   \n"
"                                                                              \n"
"  if ((! peak_includes_equals)                                                \n"
"      && ((peak_min & (! mp.min_modified))                                    \n"
"          || (peak_max & (! mp.max_modified))))                               \n"
"    return;                                                                   \n"
"                                                                              \n"
"  if (o->value)                                                               \n"
"    for (i = 0; i < 3; i++)                                                   \n"
"      dst_buf[idx + i] = o->rate * 0.5 * (mp.min[i] + mp.max[i]) + (1.0 - o->rate) * pixel[i];\n"
"  else                                                                        \n"
"     for (i = 0; i < 3; i++)                                                  \n"
"      dst_buf[idx + i] = pixel[i];                                            \n"
"                                                                              \n"
"  if (o->alpha)                                                               \n"
"    dst_buf[idx + 3] = o->rate * best[3] + (1.0 - o->rate) * pixel[3];        \n"
"  else                                                                        \n"
"    dst_buf[idx + 3] = pixel[3];                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"propagate_color_to_peak (gfloat  *pixel,                                      \n"
"                         gfloat **neighbors,                                  \n"
"                         gint     n_neighbors,                                \n"
"                         gfloat  *dst_buf,                                    \n"
"                         gint     idx,                                        \n"
"                         GeglProperties *o)                                   \n"
"{                                                                             \n"
"  gint   i, vdc;                                                              \n"
"  gfloat best[4], color[3], tmp;                                              \n"
"                                                                              \n"
"  MiddlePacket mp;                                                            \n"
"                                                                              \n"
"  gint peak_max = 1;                                                          \n"
"  gint peak_min = 1;                                                          \n"
"  gint peak_includes_equals = 1;                                              \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color, babl_format (\"R'G'B' float\"), &color);    \n"
"                                                                              \n"
"  memcpy (best, pixel, sizeof (gfloat) * 4);                                  \n"
"                                                                              \n"
"  mp.original_value = mp.minv = mp.maxv = square_pixel (pixel);               \n"
"  mp.min_modified = mp.max_modified = 0;                                      \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    mp.min[i] = mp.max[i] = pixel[i];                                         \n"
"                                                                              \n"
"  for (i = 0; i < n_neighbors; i++)                                           \n"
"    {                                                                         \n"
"      tmp = square_pixel (neighbors[i]);                                      \n"
"      vdc = value_difference_check (pixel, neighbors[i], o->upper_threshold, o->lower_threshold);\n"
"                                                                              \n"
"      if ((tmp <= mp.minv) && vdc)                                            \n"
"        {                                                                     \n"
"          mp.minv = tmp;                                                      \n"
"          memcpy (mp.min, neighbors[i], sizeof (gfloat) * 3);                 \n"
"          mp.min_modified = 1;                                                \n"
"        }                                                                     \n"
"      if ((mp.maxv <= tmp) && vdc)                                            \n"
"        {                                                                     \n"
"          mp.maxv = tmp;                                                      \n"
"          memcpy (mp.max, neighbors[i], sizeof (gfloat) * 3);                 \n"
"          mp.max_modified = 1;                                                \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (! ((peak_min & (mp.minv == mp.original_value))                          \n"
"         || (peak_max & (mp.maxv == mp.original_value))))                     \n"
"    return;                                                                   \n"
"                                                                              \n"
"  if (peak_includes_equals                                                    \n"
"      && ((peak_min & (! mp.min_modified))                                    \n"
"          || (peak_max & (! mp.max_modified))))                               \n"
"    return;                                                                   \n"
"                                                                              \n"
"  if (o->value)                                                               \n"
"    for (i = 0; i < 3; i++)                                                   \n"
"      dst_buf[idx + i] = o->rate * color[i] + (1.0 - o->rate) * pixel[i];     \n"
"  else                                                                        \n"
"    for (i = 0; i < 3; i++)                                                   \n"
"      dst_buf[idx + i] = pixel[i];                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"propagate_color (gfloat  *pixel,                                              \n"
"                 gfloat **neighbors,                                          \n"
"                 gint     n_neighbors,                                        \n"
"                 gfloat  *dst_buf,                                            \n"
"                 gint     idx,                                                \n"
"                 GeglProperties *o)                                           \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gfloat best[4], color[3];                                                   \n"
"                                                                              \n"
"  gegl_color_get_pixel (o->color, babl_format (\"R'G'B' float\"), &color);    \n"
"                                                                              \n"
"  memcpy (best, pixel, sizeof(gfloat) * 4);                                   \n"
"                                                                              \n"
"  for (i = 0; i < n_neighbors; i++)                                           \n"
"    {                                                                         \n"
"      if (GEGL_FLOAT_EQUAL (color[0], neighbors[i][0]) &&                     \n"
"          GEGL_FLOAT_EQUAL (color[1], neighbors[i][1]) &&                     \n"
"          GEGL_FLOAT_EQUAL (color[2], neighbors[i][2]) &&                     \n"
"          value_difference_check (pixel, neighbors[i], o->upper_threshold, o->lower_threshold))\n"
"        {                                                                     \n"
"          memcpy (best, neighbors[i], sizeof(gfloat) * 3);                    \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  set_pixel (pixel, best, dst_buf, idx, o);                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"propagate_opaque (gfloat  *pixel,                                             \n"
"                  gfloat **neighbors,                                         \n"
"                  gint     n_neighbors,                                       \n"
"                  gfloat  *dst_buf,                                           \n"
"                  gint     idx,                                               \n"
"                  GeglProperties *o)                                          \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gfloat best[4];                                                             \n"
"                                                                              \n"
"  memcpy (best, pixel, sizeof (gfloat) * 4);                                  \n"
"                                                                              \n"
"  for (i = 0; i < n_neighbors; i++)                                           \n"
"    {                                                                         \n"
"      if ((best[3] < neighbors[i][3]) &&                                      \n"
"          value_difference_check (pixel, neighbors[i], o->upper_threshold, o->lower_threshold))\n"
"        {                                                                     \n"
"          memcpy (best, neighbors[i], sizeof (gfloat) * 4);                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  set_pixel (pixel, best, dst_buf, idx, o);                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"propagate_transparent (gfloat  *pixel,                                        \n"
"                       gfloat **neighbors,                                    \n"
"                       gint     n_neighbors,                                  \n"
"                       gfloat  *dst_buf,                                      \n"
"                       gint     idx,                                          \n"
"                       GeglProperties *o)                                     \n"
"{                                                                             \n"
"  gint   i;                                                                   \n"
"  gfloat best[4];                                                             \n"
"                                                                              \n"
"  memcpy (&best, pixel, sizeof (gfloat) * 4);                                 \n"
"                                                                              \n"
"  for (i = 0; i < n_neighbors; i++)                                           \n"
"    {                                                                         \n"
"      if ((neighbors[i][3] < best[3]) &&                                      \n"
"          value_difference_check (pixel, neighbors[i], o->upper_threshold, o->lower_threshold))\n"
"        {                                                                     \n"
"          memcpy (best, neighbors[i], sizeof (gfloat) * 4);                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  set_pixel (pixel, best, dst_buf, idx, o);                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"  GeglProperties          *o    = GEGL_PROPERTIES (operation);                \n"
"  VPParamsType            *params;                                            \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    o->user_data = g_slice_new0 (VPParamsType);                               \n"
"                                                                              \n"
"  params = (VPParamsType *) o->user_data;                                     \n"
"                                                                              \n"
"  params->offset_left   = o->left   ? -1 : 0;                                 \n"
"  params->offset_top    = o->top    ? -1 : 0;                                 \n"
"  params->offset_right  = o->right  ?  1 : 0;                                 \n"
"  params->offset_bottom = o->bottom ?  1 : 0;                                 \n"
"                                                                              \n"
"  area->left = area->right = area->top = area->bottom = 1;                    \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"R'G'B'A float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_slice_free (VPParamsType, o->user_data);                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (in_rect)                                                                \n"
"  {                                                                           \n"
"    result = *in_rect;                                                        \n"
"  }                                                                           \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl     *format = babl_format (\"R'G'B'A float\");                   \n"
"  GeglRectangle   src_rect;                                                   \n"
"  gfloat         *src_buf;                                                    \n"
"  gfloat         *dst_buf;                                                    \n"
"  VPParamsType   *params;                                                     \n"
"  gint            x, y, ix, iy, i;                                            \n"
"  gfloat         *pixel;                                                      \n"
"                                                                              \n"
"  params = (VPParamsType *) o->user_data;                                     \n"
"                                                                              \n"
"  if (!(o->left || o->right || o->top || o->bottom) ||                        \n"
"      !(o->value || o->alpha) ||                                              \n"
"       (o->upper_threshold < o->lower_threshold))                             \n"
"    {                                                                         \n"
"      gegl_buffer_copy (input, NULL, GEGL_ABYSS_CLAMP,                        \n"
"                        output, NULL);                                        \n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  src_rect = gegl_operation_get_required_for_output (operation, \"input\", roi);\n"
"                                                                              \n"
"  dst_buf = g_new0 (gfloat, roi->width * roi->height * 4);                    \n"
"  src_buf = g_new0 (gfloat, src_rect.width * src_rect.height * 4);            \n"
"                                                                              \n"
"  gegl_buffer_get (input, &src_rect, 1.0, format, src_buf,                    \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);                    \n"
"                                                                              \n"
"  for (y = 0; y < roi->height; y++)                                           \n"
"    {                                                                         \n"
"      for (x = 0; x < roi->width; x++)                                        \n"
"        {                                                                     \n"
"          gfloat *neighbors[8] = { NULL, };                                   \n"
"          gint    n_neighbors;                                                \n"
"          gint    idx;                                                        \n"
"                                                                              \n"
"          idx = (x + y * roi->width) * 4;                                     \n"
"                                                                              \n"
"          ix = x + 1;                                                         \n"
"          iy = y + 1;                                                         \n"
"                                                                              \n"
"          pixel = src_buf + (ix + iy * src_rect.width) * 4;                   \n"
"                                                                              \n"
"          /* get neighbors */                                                 \n"
"                                                                              \n"
"          n_neighbors = get_pixel_neighbors (src_buf,                         \n"
"                                             ix,                              \n"
"                                             iy,                              \n"
"                                             src_rect.width,                  \n"
"                                             params,                          \n"
"                                             neighbors);                      \n"
"          switch (o->mode)                                                    \n"
"            {                                                                 \n"
"              default:                                                        \n"
"              case GEGL_VALUE_PROPAGATE_MODE_WHITE:                           \n"
"                propagate_white (pixel, neighbors, n_neighbors, dst_buf, idx, o);\n"
"                break;                                                        \n"
"                                                                              \n"
"              case GEGL_VALUE_PROPAGATE_MODE_BLACK:                           \n"
"                propagate_black (pixel, neighbors, n_neighbors, dst_buf, idx, o);\n"
"                break;                                                        \n"
"                                                                              \n"
"              case GEGL_VALUE_PROPAGATE_MODE_MIDDLE:                          \n"
"                for (i = 0; i < 4; i++)                                       \n"
"                  dst_buf[idx + i] = pixel[i];                                \n"
"                                                                              \n"
"                propagate_middle (pixel, neighbors, n_neighbors, dst_buf, idx, o);\n"
"                break;                                                        \n"
"                                                                              \n"
"              case GEGL_VALUE_PROPAGATE_MODE_COLOR_PEAK:                      \n"
"                for (i = 0; i < 4; i++)                                       \n"
"                  dst_buf[idx + i] = pixel[i];                                \n"
"                                                                              \n"
"                propagate_color_to_peak (pixel, neighbors, n_neighbors, dst_buf, idx, o);\n"
"                break;                                                        \n"
"                                                                              \n"
"              case GEGL_VALUE_PROPAGATE_MODE_COLOR:                           \n"
"                propagate_color (pixel, neighbors, n_neighbors, dst_buf, idx, o);\n"
"                break;                                                        \n"
"                                                                              \n"
"              case GEGL_VALUE_PROPAGATE_MODE_OPAQUE:                          \n"
"                propagate_opaque (pixel, neighbors, n_neighbors, dst_buf, idx, o);\n"
"                break;                                                        \n"
"                                                                              \n"
"              case GEGL_VALUE_PROPAGATE_MODE_TRANSPARENT:                     \n"
"                propagate_transparent (pixel, neighbors, n_neighbors, dst_buf, idx, o);\n"
"                break;                                                        \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, roi, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);     \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass             *object_class;                                     \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:value-propagate\",                                \n"
"    \"title\",       _(\"Value Propagate\"),                                  \n"
"    \"categories\",  \"distort\",                                             \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Propagate certain colors to neighboring pixels.\"),  \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
